	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _GUISERVER_IMPL_H
#define _GUISERVER_IMPL_H

#include "artsbuilder.h"
#include "artsobject.h"
#include "qwidget.h"
#include "qlayout.h"
#include "guimodule.h"

class GUIServer_impl :public ArtsObject_impl,
						public Arts::ArtsServer_skel,
						public ArtsBuilder::GUIServer_skel
						 
{
	CORBA::Long _ID;
	Arts::ModuleBroker_var ModuleBroker;
	Arts::Synthesizer_var Synthesizer;
	QWidget *globalParent;
	QBoxLayout *globalLayout;
	list<GuiModule *> modules;
	long nextMID;
	long nextGlobalID;

public:
	GUIServer_impl(Arts::ModuleBroker *Broker, Arts::Synthesizer *Synthesizer);
	void cleanUp();

	void setGlobalParent(QWidget *globalParent);
	void setGlobalLayout(QBoxLayout *globalLayout);

	// reoccuring timer tick (currently ever 2 seconds)
	void tick();

// export CORBA functions for the gui server (ArtsServer interface)

	CORBA::Long ID();

    CORBA::Long createModules();
    CORBA::Boolean createModule(CORBA::Long mid, Arts::ModuleDesc *desc);
    CORBA::Boolean localConnectModules(CORBA::Long mid);
	CORBA::Boolean remoteConnectModules(CORBA::Long mid, CORBA::Long remotemid,
		const Arts::ModuleDescSeq& modules, Arts::ArtsServer *server);
    CORBA::Boolean finalizeModules(CORBA::Long mid);
    void startModules(CORBA::Long mid);
    void deleteModules(CORBA::Long mid);
    void requestSignal(CORBA::Long mid, CORBA::Long portid,
		Arts::Receiver *receiver);

	// flow server session management
	
	CORBA::Boolean saveSessionModules(CORBA::Long mid,
			Arts::StringSeq*& data, Arts::IDSeq*& structureIDs);

	CORBA::Boolean restoreSessionModules(CORBA::Long mid,
			const Arts::StringSeq& data, CORBA::Long restoreID);
};

#endif
