    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _PARAMETERS_H_
#define _PARAMETERS_H_

#include <string>
#include <list>

class Parameter;

class ParameterObserver {
public:
	virtual void parameterChanged(const Parameter *param) = 0;
};

class Parameter {
protected:
	float _floatValue;
	string _stringValue;
	string _name;
	list<ParameterObserver *> observers;

public:
	Parameter(const char *name);

	inline const char *name() { return _name.c_str(); }

	// TODO: check wether inheritance is required as soon as there are
	// more datatypes available
	inline float floatValue() const { return _floatValue; }
	void setFloatValue(float newValue);

	inline string stringValue() const { return _stringValue; }
	void setStringValue(string newValue);

	void startObserve(ParameterObserver *observer);
	void stopObserve(ParameterObserver *observer);
};

class ParameterManager {
protected:
	list<Parameter *> parameters;

	ParameterManager();
public:
	static ParameterManager *the();
	Parameter *lookupParameter(const char *name);
};

#endif
