	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <sys/types.h>
#include <sys/time.h>
#include <math.h>
#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <fcntl.h>
#include "synth_impl.h"
#include "artsorb.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

void rt_error()
{
  	fprintf(stderr," This means that this program will likely not be able\n");
  	fprintf(stderr," to produce acceptable sound (without clicks and breaks).");
	fprintf(stderr,"\n\n");
}

#ifdef HAVE_REALTIME_SCHED
#include <sched.h>

void adjust_priority()
{
	int sched = sched_getscheduler(0);
	if(sched == SCHED_FIFO || sched == SCHED_RR)
	{
		printf(">> since the scheduling policy is not standard, I assume\n");
		printf("   it has been adjusted to fit the needs of realtime audio\n");
	}
	else
	{
		struct sched_param sp;
		long priority = (sched_get_priority_max(SCHED_FIFO) +
			             sched_get_priority_min(SCHED_FIFO))/2;
		              
		sp.sched_priority = priority;

		if(sched_setscheduler(0, SCHED_FIFO, &sp) == 0)
		{
			printf(">> running as realtime process now (priority %ld)\n",
																	priority);
		}
		else
		{
			fprintf(stderr,"\nWARNING: Can't get realtime priority ");
			fprintf(stderr," (try running as root)!\n");
			rt_error();
		}
	}
}
#else
void adjust_priority()
{
	int prio;

	prio = getpriority(PRIO_PROCESS,getpid());
	if(prio < -10)
	{
		setpriority(PRIO_PROCESS,getpid(),-17);
		prio = getpriority(PRIO_PROCESS,getpid());
	}

  	fprintf(stderr,
		"\nWARNING: Your system doesn't support realtime scheduling.\n");
	rt_error();

	if(prio > -10) {
		printf(">> synthesizer priority is %d (which is unacceptable,",prio);
		printf(" try running as root)\n");
	}
	else {
		printf(">> synthesizer priority is %d (which is the best\n",prio);
		printf("   we can get out of a non realtime system)\n");
	}
}
#endif

#ifdef COMMON_BINARY
int synth_server_main(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
	adjust_priority();

    // drop root priviliges if running setuid root
    // (due to realtime priority stuff)
    if (geteuid() != getuid()) seteuid(getuid());                               

	// init ORB
	CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "mico-local-orb");
    CORBA::BOA_var boa = orb->BOA_init (argc, argv, "mico-local-boa");

	// to let ArtsObject and the Synthesizer access ORB functions, such
	// as registering IO events or shutting down the ORB on completion

	ArtsOrb = orb;
	ArtsBoa = boa;

	// will delete itself when no longer needed
	Arts::Synthesizer_ptr synth = new Synthesizer_impl;
	printf("%s\n",orb->object_to_string(synth));
	boa->impl_is_ready( CORBA::ImplementationDef::_nil() );
	orb->run();

	printf("... leaving synth_server\n");
	return 0;
}
