/***************************************************************************
                          encoder.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Apr 14 1999                                           
    copyright            : (C) 1999 by ROLLY Arnaud                         
    email                : rolly@technologist.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "encoder.h"

#include <qdir.h>
#include <qframe.h>
#include <qmultilinedit.h>

#include <iostream>

Encoder::Encoder(KBlade *blade, QWidget *parent, const char *name ) : QDialog(parent,name, true)
{
	setCaption("KBlade : Searching WAVs");
	setFixedSize(320, 130);
	
	wav = new QLabel("WAV :", this);
	CHECK_PTR(wav);
	wav->setGeometry(5, 5, 300, 20);
	mp3 = new QLabel("MP3 :", this);
	CHECK_PTR(mp3);
	mp3->setGeometry(5, 25, 300, 20);
	bar = new QProgressBar(1000, this);
	CHECK_PTR(bar);
	bar->setGeometry(5, 50, 300, 30);
	mainBtn = new QPushButton("&Cancel", this);
	CHECK_PTR(mainBtn);
	mainBtn->setGeometry(5, 90, 60, 30);
	connect(mainBtn, SIGNAL(clicked()), this, SLOT(slotCancel()));
	
	kblade = blade;
	lastEncodedFile = 0;
	p = NULL;

	go = new QTimer();
	CHECK_PTR(go);
	connect(go, SIGNAL(timeout()), this, SLOT(slotEncode()));
	go->start(1);
}

Encoder::~Encoder()
{
}

void Encoder::slotEncode()
{
	go->stop();
	
	setCaption("KBlade : Encoding");
	encodeNewFile();
}

void Encoder::convert(QString &in)
{
	// Create a new process
	if (p != NULL)
		delete p;
	p = new KProcess();
	CHECK_PTR(p);
	
	// Listen the new process's std out/err
	connect(p, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(slotBladeEncStdOut(KProcess *, char *, int)));
	connect(p, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(slotBladeEncStdErr(KProcess *, char *, int)));
	connect(p, SIGNAL(processExited(KProcess *)), this, SLOT(slotEncodeNewFile(KProcess *)));

	// Specify the process's command line
	QString cmdLine;
	
	*p << "bladeenc";
	*p << "-QUIT";
	
	cmdLine = "-";
	cmdLine += kblade->getCmdLineBitrate();
	*p << cmdLine;
	
	if (kblade->getCmdLineCrc())
		*p << "-CRC";
	if (kblade->getCmdLinePrivate())
		*p << "-PRIVATE";
	if (kblade->getCmdLineCopyright())
		*p << "-COPYRIGHT";
	if (!kblade->getCmdLineOriginal())
		*p << "-COPY";
	if (kblade->getCmdLineDelete())
		*p << "-DELETE";
	if (kblade->getCmdLineMono())
		*p << "-MONO";
	
	*p << in;
	
	// Launch the process
	if (!p->start(KProcess::NotifyOnExit, KProcess::AllOutput))
	{
		wav->setText("Execution of bladeenc failed!");
		mp3->setText("Please verify bladeenc install.");
		mainBtn->setText("OK");
	}
}

void Encoder::slotCancel()
{
	if (p != NULL && p->isRunning())
		p->kill();
	delete this;
}

void Encoder::slotBladeEncStdOut(KProcess *proc, char *buffer, int len)
{
	QString progress = buffer;
	if (progress.contains("ERROR"))
	{
		kblade->addError(progress.mid(progress.find("ERROR") + 7, progress.find('!', progress.find("ERROR"))- progress.find("ERROR") - 7));
		p->kill();
	}
	else
	{
		progress = progress.left(progress.find('%'));
		progress = progress.right(4);
		bar->setProgress(progress.toFloat() * 10);
	}
}

void Encoder::slotBladeEncStdErr(KProcess *proc, char *buffer, int len)
{
	kblade->addError(buffer);
	p->kill();
}

void Encoder::encodeNewFile()
{
	if (lastEncodedFile == kblade->countFiles())
	{
		setCaption("KBlade : Done");
		QString errMsg;
		switch (kblade->countErrors())
		{
			case 0:
				errMsg = "No errors occured.";
				break;
			case 1:
				errMsg = "1 error occured!";
				break;
			default:
				errMsg.setNum(kblade->countErrors());
				errMsg += " errors occured!";
				break;
		}
		mp3->setText(errMsg);
		wav->setText("Encoding finished.");
		bar->hide();
		mainBtn->setText("OK");
		return;
	}
	
	bar->reset();
	
	QString in = kblade->getFile(lastEncodedFile);
	kblade->delFile(lastEncodedFile);
	
	QFileInfo infoIn(in);
	if (infoIn.exists())
	{
		QString out = in.left(in.length() - 3) + "mp3";
	
		wav->setText("WAV : " + in);
		mp3->setText("MP3  : " + out);
	
		convert(in);
	} else
	{
		kblade->addError(in + " does not exists!");
		encodeNewFile();
	}
}

void Encoder::slotEncodeNewFile(KProcess *)
{
	encodeNewFile();
}






