/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "alarmtimer.h"
#include <iostream.h>
#include "../config.h"

AlarmTimer::AlarmTimer( QObject *parent=0, const char *name=0 )
  : QObject(parent,name) {
  streamInfoDevice = NULL;
  alarmTime = -1;  
  timerId   = 0;
}

AlarmTimer::~AlarmTimer(){ 
  if(streamInfoDevice != 0)
    disconnect(streamInfoDevice->getEventQueue(),NULL, this, NULL);
  streamInfoDevice = NULL;
}


void AlarmTimer::timerEvent( QTimerEvent * ){
  checkAlarmTime();
}

void AlarmTimer::checkAlarmTime(){ 
  int currentTime = streamInfoDevice->getTimeInfo()->getTotalSec();
  if (alarmTime == -1) return;
  if (alarmTime <= currentTime){
    stopAlarmTimer();
    alarmTime = -1;
    emit alarm();
  }
}

void AlarmTimer::stopAlarmTimer(){
  if (timerId)  {
    killTimer(timerId);
    timerId = 0;
  }
}

void AlarmTimer::startAlarmTimer(){
  if (!timerId)  timerId = startTimer(400);
}

void AlarmTimer::clearAlarmTime()      {     
  alarmTime = -1; 
  stopAlarmTimer();
}

void AlarmTimer::setAlarmTime(int time){   
  alarmTime = time; 
  if(streamInfoDevice->getStatusInfo()->getStatus() == _STATUS_PLAYING){	
    startAlarmTimer();
  }
}

void AlarmTimer::attachTo(AudioStreamInfoDevice* streamDevice) {
  if (streamInfoDevice != NULL) {
    debugOutput( cout << "error:  connecting to already connected AlarmTimer!"<<endl );
    exit(1);
  }
  streamInfoDevice=streamDevice;
  connect(streamInfoDevice->getEventQueue(),SIGNAL(processEvent(char)),
	  this,SLOT(processEvent(char)));
}

void AlarmTimer::detach() {
  stopAlarmTimer();
  disconnect(streamInfoDevice->getEventQueue(),NULL,this,NULL);
  streamInfoDevice=NULL;
}


void AlarmTimer::processEvent(char eventId) {
  switch (eventId) {
  case _AUDIOSTREAMINFO_STATUS_CHANGE : {
    if(streamInfoDevice->getStatusInfo()->getStatus() == _STATUS_STOPPED){
      stopAlarmTimer();    
    }
    else{ 
      if(streamInfoDevice->getStatusInfo()->getStatus() == _STATUS_PLAYING){	
	startAlarmTimer();
      }
    }
    break;
  }
  case _AUDIOSTREAMINFO_MUSIC_CHANGE : {
    if(streamInfoDevice->getMusicInfo()->getLen() < alarmTime){
      clearAlarmTime();
    }
    break;
  }
  }
}

