/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "ktable.h"

KTable::KTable(QWidget *parent, const char *name, int spalten) 
  :KTabListBox(parent,name, spalten){ 
  lastSelection = -1;
}

void KTable::focusOutEvent ( QFocusEvent *e){
  lastSelection = currentItem();
  unmarkAll();
  KTabListBox::focusOutEvent(e);
}

void KTable::focusInEvent  ( QFocusEvent *e ){
  if(lastSelection != -1)
    setCurrentItem(lastSelection);
  else
    setCurrentItem(0);
  KTabListBox::focusInEvent(e);  
}


