/*
  this class stores important data about audio streams
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/stream/audioStream.h>


AudioStream::AudioStream() {
  audioBuffer=new AudioBuffer();
  audioInfo=new AudioInfo();
  musicInfo=new MusicInfo();
  timeInfo=new TimeInfo();
  volumeInfo=new VolumeInfo();
}


AudioStream::~AudioStream() {
  delete audioBuffer;
  delete audioInfo;
  delete musicInfo;
  delete timeInfo;
  delete volumeInfo;
}


void AudioStream::setAudioInfo(AudioInfo* aAudioInfo) {
  aAudioInfo->copyTo(audioInfo);
}


AudioInfo* AudioStream::getAudioInfo() {
  return audioInfo;
}


void AudioStream::setVolumeInfo(VolumeInfo* aVolumeInfo) {
  aVolumeInfo->copyTo(volumeInfo);
}


VolumeInfo* AudioStream::getVolumeInfo() {
  return volumeInfo;
}



void AudioStream::setMusicInfo(MusicInfo* aMusicInfo) {
  aMusicInfo->copyTo(musicInfo);
}


MusicInfo* AudioStream::getMusicInfo() {
  return musicInfo;
}


void AudioStream::setAudioBuffer(AudioBuffer* aAudioBuffer) {
  aAudioBuffer->copyTo(audioBuffer);
}


AudioBuffer* AudioStream::getAudioBuffer() {
  return audioBuffer;
}


void AudioStream::setTimeInfo(TimeInfo* aTimeInfo) {
  aTimeInfo->copyTo(timeInfo);
}


TimeInfo* AudioStream::getTimeInfo() {
  return timeInfo;
}


void AudioStream::forward() {
  audioBuffer->setChange(false);
  audioBuffer->setMemChunk(NULL);

  audioInfo->setChange(false);
  musicInfo->setChange(false);
  timeInfo->setChange(false);
  volumeInfo->setChange(false);
  Stream::forward();
}


void AudioStream::print() {
  cout << "audioStream - print [START]"<<endl;
  audioBuffer->print();
  audioInfo->print();
  musicInfo->print();
  timeInfo->print();
  volumeInfo->print();
  Stream::print();
  cout << "audioStream - print [END]"<<endl;
}


void AudioStream::copyTo(AudioStream* dest) {

  dest->setAudioBuffer(getAudioBuffer());
  dest->setAudioInfo(getAudioInfo());
  dest->setVolumeInfo(getVolumeInfo());
  dest->setMusicInfo(getMusicInfo());
  dest->setTimeInfo(getTimeInfo());
  Stream::copyTo(dest);
}


int AudioStream::isValid() {
  return true;
}


void AudioStream::addLock() {
  MemChunk* memChunk=audioBuffer->getMemChunk();
  // If shared data _not_ avaiable, there is no need to lock it
  if (memChunk == NULL) {
    return;
  }
  memChunk->addLock();
}


void AudioStream::removeLock() {
  MemChunk* memChunk=audioBuffer->getMemChunk();
  // If shared data _not_ avaiable, there is no need to lock it
  if (memChunk == NULL) {
    return;
  }
  memChunk->removeLock();
}
 
