/*
  implements a directed stream graph
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __YAFGRAPH_H
#define __YAFGRAPH_H


#include <devices/nodeDevice.h>
#include <graph/edges.h>

typedef struct {
  struct NodeDevice* source;
  struct NodeDevice* listener;
  int valid;
} Connection ;


#define _MAX_CONNECTION 20

/**
  A YafGraph stores the nodes and the devices. In this structure
  the library stores the nodes, and how they are connected to
  each other.
  <p>
  A devices knows the graphs to which it belongs.
  It can query the graph to get the connected sources and
  listeners. This is used if a device enters the connected
  listeners.
  <p>

*/

class YafGraph {


  Connection* connectTable[_MAX_CONNECTION];

 public:
  YafGraph();
  ~YafGraph();

  void connect(struct NodeDevice* source,struct NodeDevice* listener);
  void disconnect(struct NodeDevice* source,struct NodeDevice* listener);

  void getListeners(struct NodeDevice* source,struct Edges* edges);
  void getSources(struct NodeDevice* listener,struct Edges* edges);

};

#endif


  
