/*
  adds basic commands for a xplayer and controls a yafClient.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <producer/yaf/yafXPlayerControl.h>
#include "../../../../config.h"



YafXPlayerControl::YafXPlayerControl()  {
  rt = new RuntimeTableXPlayer();
  ct = new CommandTableXPlayer();

  appendRuntimeTable(rt);
  appendCommandTable(ct);

  // if more is needed, the buffer autmatically grows
  lineStack=new LineStack();  
  lineBuffer=new Buffer(300);
  onlineCounter=0;
}



YafXPlayerControl::~YafXPlayerControl()  {
  delete rt;
  delete ct;
  delete lineBuffer;
  delete lineStack;
}  


int YafXPlayerControl::open(char* filename ){
  int back;
  QString msg("open ");
  QString name(filename);
  msg=msg+name+"\n";
  back=bufferedSend(msg.data());
  return back;
}
  
int YafXPlayerControl::close() {
  int back;
  back=bufferedSend("off\n");
  return back;
}

int YafXPlayerControl::play() {
  int back;
  back=bufferedSend("play\n");
  return back;
}

int YafXPlayerControl::pause() {
  int back;
  back=bufferedSend("pause\n");
  return back;
}


int YafXPlayerControl::jump(int nPos) {
  int back;
  QString msg("jump ");
  QString number;
  
  msg=msg+number.setNum(nPos)+"\n";
  back=bufferedSend(msg.data());
  return back;
}


int YafXPlayerControl::send(char* msg) {
  return bufferedSend(msg);
}




void YafXPlayerControl::setOnline(int online) {
  if (onlineCounter < 0) {
    debugOutput( cout << "error : Online recursive Stack mismatsch!"<<endl );
  }
  if (online == true) {
    if (onlineCounter != 1) {
      debugOutput( cout << "error : Online recursive Stack mismatsch!"<<endl );
    }
    // send all data which is in the stack.
    onlineCounter--;
    while(lineStack->hasLine()) {
      lineStack->nextLine(lineBuffer);
      lineBuffer->append("\n");
      rawSend(lineBuffer->getData());
    }   
  } else {
    if (onlineCounter != 0) {
      debugOutput( cout << "error : Online recursive Stack mismatsch!"<<endl );
    }   
    onlineCounter++;
  }
}


int YafXPlayerControl::bufferedSend(char* msg) {
  int back;
  // "ONLINE" or command


  // command
  if (onlineCounter == 0) {
    back=YafClient::send(msg);
    return back;
  }
  
  // command has to be stacked
  back=createCommand(msg,lineBuffer);
  lineStack->appendBottom(lineBuffer->getData());
  return back;
}



