/* this file is a part of amp software, (C) tomislav uzelac 1996,1997

	Origional code by: tomislav uzelac
	Modified by:
	* Dan Nelson - BSD mods.
	* Andrew Richards - moved code from audio.c and added mixer support etc
        * Martin Vogt
 */

/* Support for Linux and BSD sound devices */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include "audioIO.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


//
//
// Why all these different system cannot make a standard where this
// soundcard.h file is ?
//



#if defined(HAVE_MACHINE_SOUNDCARD_H) 
#undef AUSIZ
#include <machine/soundcard.h>
#else

#if defined(HAVE_SYS_SOUNDCARD_H)
#undef AUSIZ
#include <sys/soundcard.h>
#else

#if defined(HAVE_LINUX_SOUNDCARD_H)
#include <linux/soundcard.h>
#endif
#endif
#endif


/* optimal fragment size */

int AUSIZ = 0;

// declare these static to effectively isolate the audio device 

static int audio_fd;
static int mixer_fd;
static int volumeIoctl;


/* 
   should open the audio device, perform any special initialization	
*/
int  audioOpen() {
  return audioOpen("/dev/dsp");
}


int audioOpen(const char *device){
  audio_fd = open (device, O_WRONLY, 0);
  //audio_fd = open ("./b.wav", O_RDWR | O_CREAT, 644);
  if (audio_fd < 0)  {
    perror("Unable to open the audio");
  }

  // Ok here something important if your programm forks:
  if (audio_fd > 0) {
    if (fcntl(audio_fd,F_SETFD,true) < 0) {
      perror("fcntl socket");exit(1);
    }
  }
  
  return (audio_fd > 0);
}


void audioInit(int sampleSize,int frequency, int stereo) {
  int supportedMixers, play_format=AFMT_S16_LE;

  
  if (ioctl(audio_fd, SNDCTL_DSP_SETFMT,&play_format) < 0) {
    perror("Unable to set required audio format\n");
  }
  if ((mixer_fd=open("/dev/mixer",O_RDWR)) == -1) {
    warn("Unable to open mixer device\n");
  }
  
  DB(audio, msg("Mixer device opened on %d\n",mixer_fd) );
  
  if (ioctl(mixer_fd, SOUND_MIXER_READ_DEVMASK, &supportedMixers) == -1){
    warn("Unable to get mixer info assuming master volume\n");
    volumeIoctl=SOUND_MIXER_WRITE_VOLUME;
  } else {
    if ((supportedMixers & SOUND_MASK_PCM) != 0)
      volumeIoctl=SOUND_MIXER_WRITE_PCM;
    else
      volumeIoctl=0;
  }
  
  /* Set 1 or 2 channels */
  stereo=(stereo ? 1 : 0);
  ioctl(audio_fd,SNDCTL_DSP_RESET,NULL);
  DB(audio, msg("Setting stereo to %d\n",stereo) )
    if (ioctl(audio_fd, SNDCTL_DSP_STEREO, &stereo) < 0)
      perror("Unable to set stereo/mono\n");
  
  /* Set the output frequency */
  DB(audio, msg("Setting freq to %d Hz\n",frequency) )
    if (ioctl(audio_fd, SNDCTL_DSP_SPEED, &frequency) < 0)
      warn("Unable to set frequency: %d\n",frequency);
  /*
    if (ioctl(audio_fd,SNDCTL_DSP_SAMPLESIZE,sampleSize) < 0) {
    die("Unable to set SAMPLESIZE: %d\n",sampleSize);
    }
    
  */
  if (ioctl(audio_fd, SNDCTL_DSP_GETBLKSIZE, &AUSIZ) == -1)
    perror("Unable to get fragment size\n");
}


/* 
   only code this if your system can change the volume while 
   playing
*/
void audioSetVolume(int leftVolume,int rightVolume) {
  int volume;

  volume=leftVolume+(rightVolume<<8);
  if ((mixer_fd != -1) && (volumeIoctl!=0)) {
    if (ioctl(mixer_fd, volumeIoctl, &volume) < 0) {
      warn("Unable to set sound volume\n");
    }
  }
}



/* 
   audioFlush() 
   should flush the audio device
*/
inline void audioFlush() {
  DB(audio, msg("audio: flush %d\n",audio_fd) );
  
  if (ioctl(audio_fd, SNDCTL_DSP_RESET, 0) == -1)
    perror("Unable to reset audio device\n");
}


/* 
   should close the audio device and perform any special shutdown 
*/
void audioClose() {
  audioFlush();
  if (close(audio_fd) < 0) {
    perror("error close audiodevice:");
  }
  if (mixer_fd != -1)
    close(mixer_fd);
  DB(audio, msg("audio: closed %d\n",audio_fd) );
}


/* 
   audioWrite 
   writes count bytes from buffer to the audio device 
   returns the number of bytes actually written 
*/
int audioWrite(char *buffer, int count) {
  DB(audio, msg("audio: Writing %d bytes to audio descriptor %d\n",
		count,getAudioFd()) );

  return(write(audio_fd,buffer,count));
}


/*
  Let buffer.c have the audio descriptor so it can select on it. 
  This means  that the program is dependent on a 
  file descriptor to work. Should really  move the select's 
  etc (with inlines of course) in here so that this is the 
  ONLY file which has hardware dependent audio stuff in it
*/
int getAudioFd() {
  return(audio_fd);
}
