/*
  This class can wait for an input by the user
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <yafcore/inputInterface.h>
#include "../../../../config.h"
//define DEBUG cout << "Command:1 Msg:"


InputInterface::InputInterface(){

  currentLine= new Buffer(300);
  rawLine=new Buffer(300);
  loopback=new Buffer(300);
  protocolSyntax=false;
  currentCommandNumber=42;
  multiReader=new MultiReader();
  yafInput=new ifstream("yaf.script"); 
  if (yafInput->fail() == false) {
    insertYafScript(yafInput);
  }
  yafInput->close();
}

InputInterface::~InputInterface(){
  delete yafInput;
  delete multiReader;
  delete currentLine;
  delete rawLine;
  delete loopback;
}
 

int InputInterface::addFileDescriptor(int fd) {
  return multiReader->add(fd);
}


void InputInterface::removeFileDescriptor(int fd) {
  return multiReader->remove(fd);
}


int InputInterface::getCurrentCommandNumber() {
  return currentCommandNumber;
}

void InputInterface::increaseCurrentCommandNumber(){
  currentCommandNumber++;
}

int InputInterface::write(int fd,char* txt) {
  
  int len;

  loopback->clear();
  if (protocolSyntax == true) {
    snprintf(loopback->getData(),300,
	     "Command:41 Msg:%s",txt);
  } else {
    strcpy(loopback->getData(),txt);
  }
  len =loopback->len();
  return ::write(fd,loopback->getData(),len);
}
  


void InputInterface::waitForLine() {
  while(multiReader->hasLine() == false) {
    multiReader->waitForLine();
  }
  multiReader->getLine(rawLine);
  makeValidLine(rawLine->getData());
}

void InputInterface::setProtocolSyntax (int proto) {
  protocolSyntax=proto;
}



void InputInterface::makeValidLine(char* line) {
  int len;
  len=strlen(line);
  if (len >= 1) {
    if (line[len-1] == '\n') {
      line[len-1]='\0';
    }
  }
  if (strncmp("noprotocol",line,10) == 0){
    setProtocolSyntax(false);
    clearLine();
    increaseCurrentCommandNumber();
    snprintf(currentLine->getData(),300,
	     "Command:%d Msg:%s",currentCommandNumber,line);    
    return;
  }
  if (strncmp("protocol",line,8) ==  0 ){
    setProtocolSyntax(true);
    clearLine();
    increaseCurrentCommandNumber();
    snprintf(currentLine->getData(),300,
	     "Command:%d Msg:%s",currentCommandNumber,line);
    return;
  }

  // Now the part if we do _not_ bypass the protocol-state

  if (protocolSyntax == false) {
    clearLine();
    increaseCurrentCommandNumber();
    snprintf(currentLine->getData(),300,
	     "Command:%d Msg:%s",currentCommandNumber,line);
  } else {
    increaseCurrentCommandNumber();
    strcpy(currentLine->getData(),line);
  }
  return ;
}




void InputInterface::insertYafScript(ifstream* stream) {
  char bst;
  int nBytes=0;
  Buffer yafScriptBuffer(300);

  if (stream->fail()) return;
  while (stream->eof()==false) {
    stream->get(bst);
    if (bst == EOF) break;
    
    yafScriptBuffer.append(&bst,1);
  }
  nBytes=(yafScriptBuffer.len()-1);  // EOF is a character we dont want

  multiReader->add(&yafScriptBuffer);
}



int  InputInterface::hasLine() {
  if (currentLine->len() == 0) return 0;
  return 1;
}

void InputInterface::clearLine() {
  currentLine->clear();
}


char* InputInterface::getLine() {
  char* back=currentLine->getData();
#ifdef _DEBUG_INPUT
  ofstream infile("instream.dbg",ios::app);
  infile << back <<endl;
  infile.close();
#endif


  return back;
}



