/*
  writes stream into a file. And takes care of a few things
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __STREAMWRITER_H
#define __STREAMWRITER_H


/*
  This Streamwriter is not a class because the most
  decoders are written in plain C and it would
  make problems to patch them to make them understand C++.

  Thus make sure, that if you include this header from a C++
  class that it has the wrapper:

  
  extern "C" { 
  #include <yafcore/streamWriter.h>
             }
	     
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/un.h>
#include <iostream.h>
#include <errno.h>
#include <unistd.h>



// called _once_ by inputDecoderXPlayer !
extern void StreamWriter_Construct(void* out);
extern void StreamWriter_Destruct();

/*

The players write to the StreamBuffer instead to
/dev/dsp

The Streambuffer functions are globally accesible. This is not
nice, but makes it easy to make a fast hack to a player.

*/

extern void StreamWriter_setStreamFile(char* filename);
extern int StreamWriter_openStream(void);
extern int StreamWriter_isOpenStream(void);

extern int StreamWriter_closeStream(void);
extern int StreamWriter_writeStream(char* buf, int len);
extern void StreamWriter_resetStream(void);
extern int StreamWriter_getBytesWrite();
extern void StreamWriter_sendStreamInfo();

void StreamWriter_sendStreamInfo(int channels,  int sampleSize, int speed);
int StreamWriter_isBlocked();

extern void StreamWriter_internalDevice(int on);
extern long StreamWriter_getBytesCounter();
extern void StreamWriter_setBytesCounter(long aValue);
extern long StreamWriter_getAllWriteCounter();


void StreamWriter_writeMessage(char* msg);

#endif;


