/***************************************************************************
                          dbhandling.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 8 1999                                           
    copyright            : (C) 1999 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <qmessagebox.h>
#include <qstring.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qlist.h>

#include "dbhandling.h"
#include "general.h"

extern QString mp3dbpath;


DBentry::DBentry(char *loc) {
 strcpy(where, loc);
 artist = "unknown";
 title = "unknown";
 album = "unknown";
 strcpy(year, "");
}

DBhandling::DBhandling(){
 dbentrieslist = new QList<DBentry>();
 listAvailable=0;
}

DBhandling::~DBhandling(){
 delete dbentrieslist;
}

void DBhandling::deleteFromDB(DBentry *item) {
 FILE *fileptr;
 FILE *tmpfileptr;
 char line[MAXLINELEN+1];
 char lineToSearch[MAXLINELEN+1];
 char tmpfile[MAXFILELEN+1];
 QString tmpmsg;

 if ((fileptr=fopen(mp3dbpath,"r"))==NULL) {
      tmpmsg = "unable to open file : ";
      tmpmsg += mp3dbpath;
      //QMessageBox::warning(this, "Error", (const char*)tmpmsg);
  		return;
 }

 sprintf(tmpfile, "%s.%d", (const char*)mp3dbpath, getpid());
 if ((tmpfileptr=fopen(tmpfile,"w"))==NULL) {
      tmpmsg = "unable to open file : ";
      tmpmsg += tmpfile;
      //QMessageBox::warning(this, "Error", (const char*)tmpmsg);
  		return;
 }
 sprintf(lineToSearch,"%s%c%s%c%s%c%s%c%s%c%s\n",
         item->where, SEPARATOR,
         (const char*)item->filename, SEPARATOR,
         strcmp((const char*)item->artist,"unknown")==0 ? "" : (const char*)item->artist, SEPARATOR,
         strcmp((const char*)item->title,"unknown")==0 ? "" : (const char*)item->title, SEPARATOR,
         strcmp((const char*)item->album,"unknown")==0 ? "" : (const char*)item->album, SEPARATOR, item->year);
 printf("about to delete line '%s'\n", lineToSearch);
 while (fgets(line, MAXLINELEN, fileptr) != NULL) {
   if (strcmp(line, lineToSearch) == 0) {
     // delete this line
     printf("deleting line '%s'\n", line);
   }
   else {
     fprintf(tmpfileptr, line);
   }
 }

 fclose(fileptr);
 fclose (tmpfileptr);
 unlink((const char*)mp3dbpath);					// delete old databasse
 rename(tmpfile,(const char*)mp3dbpath);  // rename new database
}

//
// add to or delete from db in memory
//
void DBhandling::find(char *str, bool cs, searchType type) {
 FILE *fileptr;
 QString tmpmsg;
 char line[MAXLINELEN+1];
 DBentry *dbentry;

 if (!listAvailable) {
   if ((fileptr=fopen(mp3dbpath,"r"))==NULL) {
//     tmpmsg = "unable to open file : ";
//      tmpmsg += mp3dbpath;
//      QMessageBox::warning(this, "Error", tmpmsg);
      printf("unable to open %s\n", (const char*)mp3dbpath);
  		return;
   }

   while (fgets(line, MAXLINELEN, fileptr) != NULL) {

     dbentry = getEntry(line);

     switch (type) {
       case Filename:
         //printf("filename='%s'\n", (char*)dbentry->filename);
         if (dbentry->filename.find(str, 0, cs) != -1 )  // if found
           dbentrieslist->append(dbentry);
         break;
        case Artist:
         if (dbentry->artist.find(str, 0, cs) != -1)
           dbentrieslist->append(dbentry);
         break;
       case Title:
          if (dbentry->title.find(str, 0, cs) != -1)
           dbentrieslist->append(dbentry);
         break;
       case Album:
         if (dbentry->album.find(str, 0, cs) != -1)
           dbentrieslist->append(dbentry);
         break;
       case Year:
         if (strstr(dbentry->year, str))
           dbentrieslist->append(dbentry);
         break;
       case cdname:
         if (strstr(dbentry->where, str))
           dbentrieslist->append(dbentry);
         break;
     }
   }
   fclose(fileptr);
 }
 else { // there is already a list
   dbentry=dbentrieslist->first();
   while( dbentry != 0) {
     switch (type) {
       case Filename:
         if (dbentry->filename.find(str, 0, cs) == -1 )
           dbentrieslist->remove(dbentry);
         else
           dbentry=dbentrieslist->next();
         break;
        case Artist:
         if (dbentry->artist.find(str, 0, cs) == -1)  // searchstring not found
           dbentrieslist->remove(dbentry);
         else
           dbentry=dbentrieslist->next();
         break;
       case Title:
          if (dbentry->title.find(str, 0, cs) == -1)  // searchstring not found
           dbentrieslist->remove(dbentry);
          else
           dbentry=dbentrieslist->next();
         break;
       case Album:
         if (dbentry->album.find(str, 0, cs) == 0)  // searchstring not found
           dbentrieslist->remove(dbentry);
         else
           dbentry=dbentrieslist->next();
         break;
       case Year:
         if (strstr(dbentry->year, str) == 0)  // searchstring not found
           dbentrieslist->remove(dbentry);
         else
           dbentry=dbentrieslist->next();
         break;
       case cdname:
         if (strstr(dbentry->where, str) == 0)  // searchstring not found
           dbentrieslist->remove(dbentry);
         else
           dbentry=dbentrieslist->next();
         break;
     }
     dbentry=dbentrieslist->current();
    }
  }

 listAvailable=1;
}


DBentry *DBhandling::getEntry(char *line) {
 int i=0, j=0;
 DBentry *dbentry;
 char tmpvalue[255+1];

  dbentry = new DBentry("cd");

  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("where=%s\n", tmpvalue);
  strcpy(dbentry->where, tmpvalue);

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  dbentry->filename.setStr(tmpvalue);
  //printf("getEntry() : filename='%s'\n", (char*)dbentry->filename);

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("artist=%s\n", tmpvalue);
  if (strlen(tmpvalue) >0) dbentry->artist.setStr(tmpvalue);

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("title=%s\n", tmpvalue);
  if (strlen(tmpvalue) >0) dbentry->title.setStr(tmpvalue);

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("album=%s\n", tmpvalue);
  if (strlen(tmpvalue) >0) dbentry->album.setStr(tmpvalue);

  j=0;i++;
  while ( line[i] != SEPARATOR && line[i] != '\n')
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("DBhandling::getEntry : year='%s'\n", tmpvalue);
  if (strlen(tmpvalue) >0) strcpy(dbentry->year, tmpvalue);

 return dbentry;
}

void DBhandling::clearList(void) {

 dbentrieslist->clear();
 listAvailable=0;
}
























































































































