#include <qdir.h>

// YAF include file
#include <devices/audioDevice.h>

#include <unistd.h>
#include <kmpgServer.h>
#include <ipc/ipcModule.h>
#include <kmpgCommandLine.h>
#include <amplifier/extension.h>



int main(int nargs,char** args) {
  // First we check if user want only help, before
  // we start the whole IPC stuff

  if (nargs >= 2) {
    if (strncmp(args[1],"-h",2) == 0) {
      KApplication a( nargs, args, "kmpg" );
      KmpgCommandLine::usage();
      exit(0); 
    }
    if (strncmp(args[1],"--help",6) == 0) {
      KApplication a( nargs, args, "kmpg" );
      KmpgCommandLine::usage();
      exit(0); 
    }
  }
  // Ok, no help wanted, start IPC and everything!
  // First we check if we are a client.
  IPCModule* ipcModule=new IPCModule("kmpg");
  if (ipcModule->isFirst() == false) {
    ipcModule->send(nargs,args);
    exit(0);
  }


  KApplication a( nargs, args, "kmpg" );


  Extension::addExtension("wav",_EXTENSION_WAV);
  Extension::addExtension("mp1",_EXTENSION_MP3);
  Extension::addExtension("mp2",_EXTENSION_MP3);
  Extension::addExtension("mp3",_EXTENSION_MP3);
  Extension::addExtension("mpg",_EXTENSION_MPEG);
  Extension::addExtension("dat",_EXTENSION_MPEG);
  Extension::addExtension("mpe",_EXTENSION_MPEG);
 

  KmpgServer* kmpgServer=new KmpgServer();
  kmpgServer->newPlayer();
  

  KmpgCommandLine::parse(nargs,args);

  QObject::connect(ipcModule,SIGNAL(processCommandLine(CommandLineCreator*)),
		   kmpgServer,SLOT(processCommandLine(CommandLineCreator*)));

  QObject::connect(kmpgServer,SIGNAL(closeIPCHandleForever()),
		   ipcModule,SLOT(closeIPC()));
	
  
  a.exec();

  delete ipcModule;
  delete kmpgServer;
  return 0;
}



  



