/*
  Configuration for the audioDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __AUDIODEVICECONFIG_H
#define __AUDIODEVICECONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include "sssBox.h"


class AudioDeviceConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  bool lAutoClose_cfg;
  bool lAutoInit_cfg;
  int sampleSize_cfg;
  int sampleFreq_cfg;
  int lStereo_cfg;
  

 public:
   AudioDeviceConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~AudioDeviceConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();
   

 public slots:
   int getAutoClose();
   int getAutoInit();
   int getSampleSize();
   int getSampleFreq();
   int getStereo();
   void autoInitToggle();

 private:

   QCheckBox* autoCloseBox;
   QCheckBox* overrideBox;

   SSSBox* sssBox;

};
#endif
