/*
  sends/receive commandline
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <ipc/ipcCom.h>


IPCCom::IPCCom(char* ipcFile,int lReadLoop) {
  

  unsigned int i=0;
  sockad.sun_family=AF_UNIX;

  addrlen=strlen(ipcFile)+2;
  if (addrlen > 110) {
    cout << "cannot create socket because ipcFile longer than 110 chars"<<endl;
    exit(1);
  }
  while(i<strlen(ipcFile)) {
    sockad.sun_path[i]=ipcFile[i];
    i++;
  }
  sockad.sun_path[i]=0;
  ipcSocket=::socket(AF_UNIX,SOCK_STREAM,0);
  if (ipcSocket < 0) {
    perror("socket-IPCCom Constructor");exit(1);
  }
  if (fcntl(ipcSocket,F_SETFD,true) < 0) {
    perror("fcntl socket IPCCom");exit(1);
  }
  cout << "ipcFile:"<<ipcFile<<endl;
  this->lReadLoop=lReadLoop;
  if (lReadLoop) {
    if (fcntl(ipcSocket,F_SETFL,O_NONBLOCK) < 0) {
      perror("fcntl socket IPCCom");exit(1);
    }    
    if (bind(ipcSocket,(sockaddr*)&sockad,addrlen)<0) {
      cout << "bind on:"<<ipcFile<<endl;
      perror("bind IPCCom");exit(1);
    }
    if (listen(ipcSocket,1) < 0) {
      perror("listen IPCCom");exit(1);
    }      
    socketNotifier=new QSocketNotifier(ipcSocket,QSocketNotifier::Read);
    connect(socketNotifier,SIGNAL(activated(int)),
	    this, SLOT(dataReceived(int)));
  }

}


IPCCom::~IPCCom() {

  if (lReadLoop) {
    delete socketNotifier;
  } 
  ::close(ipcSocket);
}


void IPCCom::send(int nargs,char** args) {
  IPCElement* ipcElement;

  if (::connect(ipcSocket,(sockaddr*)&sockad,addrlen)<0) {
    perror("IPCCom::send connect");exit(1);
  }
  ipcElement=new IPCElement(ipcSocket);
  
  ipcElement->send(__IPC_ID_START,"");
  ipcElement->send(__IPC_ID_INT_DATA,nargs);
  int i;
  
  for(i=0;i<nargs;i++) {
    ipcElement->send(__IPC_ID_CHAR_DATA,args[i]);
  }
 
  ipcElement->send(__IPC_ID_END,"");
  int state=ipcElement->receive();
  if (state > 0) {
    int id=ipcElement->getID();
    switch(id) {
    case __IPC_ID_END_CONFIRM:
      break;
    default:
      cout << "receive unknown IPCElement"<<endl;
      ipcElement->print();
      break;  
    }
  } else {
    cout << "unkown state from ipcElement:"<<state<<endl;
  }
  delete ipcElement;
  
}


void IPCCom::dataReceived(int socket) {
  int sd;
  unsigned int partn_len;
  struct sockaddr_un partn_ad;
  int narg;

  sd=accept(socket,(sockaddr*)&partn_ad,&partn_len);
    
  if (sd < 0) {
    perror("accept ipc");
    return;
  }
  
  if (sd > 0) {
    IPCElement* ipcElement=new IPCElement(sd);
    int lRead=true;
    while(lRead) {
      int state=ipcElement->receive();
      if (state > 0) {
	int id=ipcElement->getID();
	int len=ipcElement->getLen();
	char* data=ipcElement->getData();
	switch(id) {
	case __IPC_ID_START:
	  commandLineCreator=new CommandLineCreator();
	  break;
	case __IPC_ID_INT_DATA:
	  narg=ipcElement->getInt();
	  commandLineCreator->setNArgs(narg);
	  break;
	case __IPC_ID_CHAR_DATA:
	  commandLineCreator->addArg(data);
	  break;
	case __IPC_ID_END:
	  ipcElement->send(__IPC_ID_END_CONFIRM,"");
	  emit(processCommandLine(commandLineCreator));
	  lRead=false;
	  break;
	default:
	  cout << "receive unknown: IPCElement"<<endl;
	  ipcElement->print();
	  break;
	}
      } else {
	lRead=false;
      }
      
    }
    if (::close(sd) < 0) {
      perror("close after child send");
    }
    delete ipcElement;
  }
}




  
