/*
  Configuration Dialog for ipcModule
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __IPCCONFIG_H
#define __IPCCONFIG_H

#include <kmpgCommandLine.h>
#include <prefConfig.h>


#include <kconfig.h>
#include <kapp.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>



class IPCConfig : public PrefConfig {
 Q_OBJECT
   
   KConfig* config;
   const char* configGroup;
   int mode;
   Playlist* playlist;

 public:
  IPCConfig(const char* configGroup,
	    Playlist* playlist,QWidget * parent=0, const char * name=0 );
  ~IPCConfig();

  const char* getGroupName();
  void load();
  void save();
  void apply();

 public slots:
  void setNoArgMode(int mode);
  void grapIPCHandle();

 signals:
  void closeIPCHandleForever();

};
#endif
