/*
  Configuration Dialog for external mixer call
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <mixerConfig.h>



MixerConfig::MixerConfig(const char* configGroup,
			 QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {
  this->configGroup=configGroup;
  mixerCommand_cfg=new Buffer(40);
  config = kapp->getConfig();
  configGroup="MixerConfig";
  load();


  infoBox= new QGroupBox(i18n("External Mixer"),this, "infoBox" );
  infoBox->setGeometry(20, 40, 300, 220 );

  QVBoxLayout *vbox = new QVBoxLayout(infoBox, 5);
  vbox->addSpacing( infoBox->fontMetrics().height() );

  QWidget* w=new QWidget(infoBox);

  
  QHBoxLayout *hbox = new QHBoxLayout(w, 5);
  hbox->addSpacing( infoBox->fontMetrics().height() );

  lineLable = new QLabel(w);
  lineLable->setText(i18n("Execute :"));
  lineLable->setFixedSize(lineLable->sizeHint());


  lineEdit = new QLineEdit(w, "lineEdit");
  lineEdit->setText(mixerCommand_cfg->getData());
  lineEdit->setFixedSize(lineEdit->sizeHint());


  hbox->addWidget(lineLable,0,AlignLeft);
  hbox->addWidget(lineEdit,0,AlignLeft);
 
  vbox->addWidget(w,0,AlignLeft);

 


}


MixerConfig::~MixerConfig() {
}


const char* MixerConfig::getGroupName() {
  return i18n("Mixer");
}


void MixerConfig::load() {
  QString command;
  config->setGroup(configGroup);
  command=config->readEntry( "MixerCommand", "kmix");
  mixerCommand_cfg->clear();
  mixerCommand_cfg->append(command.data());
}


void MixerConfig::save() {
  QString command=lineEdit->text();
  
  mixerCommand_cfg->clear();
  mixerCommand_cfg->append(command.data());
  config->setGroup(configGroup);
  config->writeEntry( "MixerCommand",mixerCommand_cfg->getData());
}


void MixerConfig::apply() {
  save();
}


void MixerConfig::startExternalMixer() {
  cout <<"startExternalMixer"<<endl;
  char **arglist = (char **)malloc( 2*sizeof(char *));

  arglist[0] = mixerCommand_cfg->getData();
  arglist[1]= 0;

  pid_t myPid = fork();
  if ( myPid == 0 ) {
    execlp(mixerCommand_cfg->getData(),mixerCommand_cfg->getData(),0);
    exit(-1);
  }
}


