/*
  Configuration Dialog for external mixer call
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __MIXERCONFIG_H
#define __MIXERCONFIG_H

#include <unistd.h>
#include <prefConfig.h>
#include <yafcore/buffer.h>

#include <kconfig.h>
#include <kapp.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>



class MixerConfig : public PrefConfig {
 Q_OBJECT
   
   KConfig* config;
   const char* configGroup;
   Buffer* mixerCommand_cfg;

 public:
  MixerConfig(const char* configGroup,
	      QWidget * parent=0, const char * name=0 );
  ~MixerConfig();

  const char* getGroupName();
  void load();
  void save();
  void apply();

 public slots:
   void startExternalMixer();


 private:
  QGroupBox* infoBox;
  QLabel* lineLable;
  QLineEdit* lineEdit;

};
#endif
