/*
  dialog for open urls and add them to playlist
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <openURLDialog.h>


OpenURLDialog::OpenURLDialog(const char* configGroup,
			     QWidget * parent=0, const char * name=0 ) 
                 : QDialog(parent,name) {

  urlList=new QStrList();
  config = kapp->getConfig();
  this->configGroup=configGroup;
  load();

  QVBoxLayout *vbox3 = new QVBoxLayout(this, 5);
  vbox3->addSpacing( fontMetrics().height() );


  QLabel* lineLabel1=new QLabel(this);
  lineLabel1->setText(i18n("Enter a URL for the playlist:"));
  lineLabel1->setFixedSize(lineLabel1->sizeHint());


  lineEdit= new QComboBox (true, this );
  lineEdit->setFixedSize(QSize(300, 25));
  lineEdit->setSizeLimit(10);
  lineEdit->insertStrList(urlList);

  QLabel* lineLabel2=new QLabel(this);
  lineLabel2->setText(i18n("Note:For a list of current broadcasts look at:"));
  lineLabel2->setFixedSize(lineLabel2->sizeHint());
  
  
  QLineEdit* lineLabel3=new QLineEdit(this);
  lineLabel3->setText(i18n("http://www.icecast.org/broadcasts.phtml"));
  lineLabel3->setFixedSize(QSize(300, 25));

  vbox3->addWidget(lineLabel1,0,AlignLeft);
  vbox3->addWidget(lineEdit,0,AlignLeft);
  vbox3->addWidget(lineLabel2,0,AlignLeft);
  vbox3->addWidget(lineLabel3,0,AlignLeft);

 
  
  OACBox* oacBox=new OACBox(this);

  connect(oacBox , SIGNAL(ok()), SLOT(save()) );
  connect(oacBox , SIGNAL(apply()), SLOT(apply()) );
  connect(oacBox , SIGNAL(cancel()),this, SLOT(hide()) );

  vbox3->addWidget(oacBox,0,AlignLeft);


}

OpenURLDialog::~OpenURLDialog() {
  delete urlList;
}


const char* OpenURLDialog::getGroupName() {
  return "URL";
}


void OpenURLDialog::load() {
  QString localList(configGroup);
  config->setGroup(configGroup);
  
  char* s1="cdi:/dev/cdrom";
  char* s2="vcd:/dev/cdrom";
  char* s3="http://localhost:8000/";
  char* s4="http://24.128.8.234:8000/";
  char* s5="http://194.47.151.77:8000/";
  char* s6="http://128.164.221.132:8000/";

  localList+="URLList";
  config->readListEntry(localList,(*urlList));
  // if empty insert a few defaults

  if (urlList->count() == 0) {
    urlList->append(s1);
    urlList->append(s2);
    urlList->append(s3);
    urlList->append(s4);
    urlList->append(s5);
    urlList->append(s6);
    urlList->at(0);
  }

}


void OpenURLDialog::save() {
  config->setGroup(configGroup);
  QString localList(configGroup);
  localList+="URLList";
  config->writeEntry(localList,(*urlList));
  emit(applyEvent());
  close();
}


void OpenURLDialog::apply() {
  save();
}


void OpenURLDialog::accept() {
  apply();
  QDialog::accept();
}

const char* OpenURLDialog::getCurrentURL() {
  return lineEdit->currentText();
}
