/*
  dialog for open urls and add them to playlist
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __OPENURLDIALOG_H
#define __OPENURLDIALOG_H




#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include "oacBox.h"

class OpenURLDialog : public QDialog {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;
  QStrList* urlList;

 public:
   OpenURLDialog(const char* configGroup,
		 QWidget * parent=0, const char * name=0 );
   ~OpenURLDialog();

 public slots:
   const char* getGroupName();
   void load();
   void save();
   void apply();
   void accept();
   const char* getCurrentURL();

 signals:
   void applyEvent();

 private:   
   QComboBox* lineEdit;
   QLineEdit* lineLabel3;
};
#endif
