/*
  a view for a playlist.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __PLAYLISTVIEW1_H
#define __PLAYLISTVIEW1_H

#include <drag.h>

#include <qlistbox.h>
#include <songView1.h>
#include <playlist.h>
#include <preferences.h>
#include <menuDescription.h>
#include <playlistView1Config.h>
#include <qdropsite.h>

class PlaylistView1 :  public QListBox {
  Q_OBJECT
    Playlist* playlist;
    KDNDDropZone *dropZone;
    Preferences* preferences;
    PlaylistView1Config* playlistView1Config;
    MenuDescription* menuDescription;
    InfoDeviceConfig* infoDeviceConfig;

 public:
  PlaylistView1( Playlist* playlist,
		 QWidget * parent=0, const char * name=0, WFlags f=0 );

  ~PlaylistView1();
  
  void mousePressEvent (QMouseEvent* mouseEvent);
  void mouseDoubleClickEvent (QMouseEvent* mouseEvent );
  void mouseMoveEvent (QMouseEvent* mouseMoveEvent);

 public slots:
   void addSongEvent(Song* song,int index);
   void removeSongEvent(int index);
   void swapSongEvent(int index1,int index2);
   void clearEvent();
   void setCurrentPosEvent(int index);
   void selected(int index);
   void highlighted(int index);
   void slotDrop(KDNDDropZone*);
   void slotUp();
   void slotDown();
   void songUpdateEvent(Song* song,int index);
   void slotDelMPEG();

   // dnd from dropsite
   void dragEnterEvent( QDragEnterEvent * );
   void dragMoveEvent( QDragMoveEvent * );
   void dragLeaveEvent( QDragLeaveEvent * );
   void dropEvent( QDropEvent * );
};

#endif
