/*
  a view for a playlist.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __PLAYLISTVIEW2_H
#define __PLAYLISTVIEW2_H

#include <kapp.h>
#include <kiconloader.h>
#include <kwm.h>

#include <playlistOperation.h>
#include <playlistView1.h>
#include <qdialog.h>
#include <qpushbt.h>


class PlaylistView2 : public QDialog {
  Q_OBJECT

    Playlist* playlist;
    PlaylistView1* playlistView1;
    QWidget *buttonPanel;
    KDNDDropZone *dropZone;

   public:
      PlaylistView2(Playlist* playlist,QWidget* parent=0, const char* name=0);
      ~PlaylistView2();


   signals:
     void hideRequestEvent();

   public slots:
      // Slots connected to buttons in dialog
      void slotLoadPlaylist();
      void slotSavePlaylist();
      void slotAddPlaylist();
      void slotAddMPEG();
      void slotDelMPEG(); 
      void slotUp();
      void slotDown();
      void slotDrop(KDNDDropZone*);
      void setNameEvent(char*);
      void hideRequest();

};
#endif


