/*
  dialog for selecting where the output should go
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "selectOutputDialog.h"


SelectOutputDialog::SelectOutputDialog(QWidget* parent=0, const char * name=0 ): PrefConfig(parent,name) {

  
  lWantESD_cfg=false;
  lWantNAS_cfg=false;
  lWantNATIVE_cfg=true;
  lWantFILE_cfg=false;

  QVBoxLayout *vbox3 = new QVBoxLayout(this, 5);
  vbox3->addSpacing( fontMetrics().height() );
  
  
  QLabel* infoLabel1 = new QLabel(this);
  infoLabel1->setText(i18n("Select the output device for kmpg."));
  infoLabel1->setFixedSize(infoLabel1->sizeHint());

 
  QLabel* infoLabel2 = new QLabel(this);
  infoLabel2->setText(i18n("Possible selections are activated."));
  infoLabel2->setFixedSize(infoLabel2->sizeHint());
  
  vbox3->addWidget(infoLabel1,0,AlignLeft);
  vbox3->addWidget(infoLabel2,0,AlignLeft);


 

  boxFrame = new QGroupBox( i18n("Audio outputs"), this );
  QVBoxLayout *vbox2 = new QVBoxLayout(boxFrame, 5);
  vbox2->addSpacing( fontMetrics().height() );

  QWidget* w=new QWidget(boxFrame);
  QVBoxLayout *vbox1 = new QVBoxLayout(w, 5);
  vbox1->addSpacing( fontMetrics().height() );


  nativeUseBox = new QCheckBox(i18n("native (OSS on Linux)"),
			    w,"nativeUseBox");
  nativeUseBox->setFixedSize(nativeUseBox->sizeHint());


  esdUseBox=new QCheckBox("ESD",w,"esdUseBox");
  esdUseBox->setFixedSize(esdUseBox->sizeHint());


  nasUseBox = new QCheckBox("NAS",w,"nasUseBox");
  nasUseBox->setFixedSize(nasUseBox->sizeHint());

  fileUseBox = new QCheckBox(i18n("FILE (wav)"),w,"fileUseBox");
  fileUseBox->setFixedSize(fileUseBox->sizeHint());

  QLabel* infoLabel3 = new QLabel(w);
  infoLabel3->setText(i18n("For more: see Options..."));
  infoLabel3->setFixedSize(infoLabel3->sizeHint());

  vbox1->addWidget(nativeUseBox,0,AlignLeft);
  vbox1->addWidget(esdUseBox,0,AlignLeft);
  vbox1->addWidget(nasUseBox,0,AlignLeft);
  vbox1->addWidget(fileUseBox,0,AlignLeft);
  vbox1->addWidget(infoLabel3,0,AlignLeft);

  vbox2->addWidget(w,0,AlignLeft);
   
  vbox3->addWidget(boxFrame,0,AlignLeft);


 
  setHaveESD(false);
  setHaveNAS(false);
  setHaveNATIVE(false);
  setHaveFILE(false);
  
  updateCheckboxes();

  
  OACBox* oacBox=new OACBox(this);

  connect(oacBox , SIGNAL(ok()), SLOT(save()) );
  connect(oacBox , SIGNAL(apply()), SLOT(apply()) );
  connect(oacBox , SIGNAL(cancel()),this, SLOT(hide()) );

  vbox3->addWidget(oacBox,0,AlignLeft);


  setFixedSize(QSize(400,150));


}


SelectOutputDialog::~SelectOutputDialog() {
}


const char* SelectOutputDialog::getGroupName() {
  return "SelectOutputDialog";
}



void SelectOutputDialog::updateCheckboxes() {
  nativeUseBox->setEnabled(lHaveNATIVE);
  esdUseBox->setEnabled(lHaveESD);
  nasUseBox->setEnabled(lHaveNAS);
  fileUseBox->setEnabled(lHaveFILE);

}


void SelectOutputDialog::setHaveESD(int lHave) {
  lHaveESD=lHave;
  updateCheckboxes();
}


int SelectOutputDialog::getHaveESD() {
  return lHaveESD;
}

void SelectOutputDialog::setHaveNAS(int lHave) {
  lHaveNAS=lHave;
}

int SelectOutputDialog::getHaveNAS() {
  return lHaveNAS;
}


void SelectOutputDialog::setHaveNATIVE(int lHave){
  lHaveNATIVE=lHave;
  updateCheckboxes();
}

int SelectOutputDialog::getHaveNATIVE() {
  return lHaveNATIVE;
}

void SelectOutputDialog::setWantESD(int lHave) {
  lWantESD_cfg=lHave;
  load();
}


void SelectOutputDialog::setWantNAS(int lHave) {
  lWantNAS_cfg=lHave;
  load();
}


void SelectOutputDialog::setWantFILE(int lHave) {
  lWantFILE_cfg=lHave;
  load();
}


void SelectOutputDialog::setWantNATIVE(int lHave) {
  lWantNATIVE_cfg=lHave;
  load();
}

int SelectOutputDialog::getValidOutputMask() {
  int back=0;
  if (lHaveNATIVE & lWantNATIVE_cfg) {
    back+=_SELECT_OUPUT_NATIVE;
  }
  if (lHaveFILE & lWantFILE_cfg) {
    back+=_SELECT_OUPUT_FILE;
  }
  if (lHaveESD & lWantESD_cfg) {
    back+=_SELECT_OUPUT_ESD;
  }
  if (lHaveNAS & lWantNAS_cfg) {
    back+=_SELECT_OUPUT_NAS;
  }

  return back;
}


void SelectOutputDialog::setHaveFILE(int lHave) {
  lHaveFILE=lHave;
  updateCheckboxes();
}


int SelectOutputDialog::getHaveFILE() {
  return lHaveFILE;
}



 

void SelectOutputDialog::load() {
  // we know what the user want.
  nativeUseBox->setChecked(lWantNATIVE_cfg);
  esdUseBox->setChecked(lWantESD_cfg);
  nasUseBox->setChecked(lWantNAS_cfg);
  fileUseBox->setChecked(lWantFILE_cfg);
}


void SelectOutputDialog::save() {
  load();
  apply();
  close();
}


void SelectOutputDialog::apply() {
  lWantESD_cfg=esdUseBox->isChecked();
  lWantNAS_cfg=nasUseBox->isChecked();
  lWantNATIVE_cfg=nativeUseBox->isChecked();
  lWantFILE_cfg=fileUseBox->isChecked();
  emit(applyEvent());
}


void SelectOutputDialog::makeVisible() {
  if (isVisible()) {
    hide();
  }
  show();
}
