/*
  dialog for selecting where the output should go
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __SELECTOUTPUTDIALOG_H
#define __SELECTOUTPUTDIALOG_H



#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include "oacBox.h"

// defines must be power of 2 !!!

#define _SELECT_OUPUT_NAS     1
#define _SELECT_OUPUT_ESD     2
#define _SELECT_OUPUT_NATIVE  4
#define _SELECT_OUPUT_FILE    8



class SelectOutputDialog : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;


 public:
   SelectOutputDialog(QWidget * parent=0, const char * name=0 );
   ~SelectOutputDialog();

 public slots:
 
   void setHaveESD(int lHave);
   int getHaveESD();

   void setHaveNAS(int lHave);
   int getHaveNAS();

   void setHaveNATIVE(int lHave);
   int getHaveNATIVE();

   void setHaveFILE(int lHave);
   int getHaveFILE();


   void setWantESD(int lHave);
   void setWantNAS(int lHave);
   void setWantFILE(int lHave);
   void setWantNATIVE(int lHave);

  
   int getValidOutputMask();

   const char* getGroupName();

   void load();
   void save();
   void apply();
   void makeVisible();

 signals:
   void applyEvent();


 private:   
   void updateCheckboxes();

   QCheckBox* nativeUseBox;
   QCheckBox* esdUseBox;
   QCheckBox* nasUseBox;
   QCheckBox* fileUseBox;
   QGroupBox* boxFrame;


   int lHaveESD;
   int lHaveNAS;
   int lHaveNATIVE;
   int lHaveFILE;

   int lWantESD_cfg;
   int lWantNAS_cfg;
   int lWantNATIVE_cfg;
   int lWantFILE_cfg;
};
#endif

