/*
  a view for a song.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <songView1.h>



SongView1::SongView1(Song* song,InfoDeviceConfig* infoDeviceConfig) {
  songName=new Buffer(40);

  this->song=song;
  this->infoDeviceConfig=infoDeviceConfig;
  doUpdate();
}


SongView1::~SongView1() {
  delete songName;
}


void SongView1::doUpdate() {
  infoDeviceConfig->translate(song,songName);
  setText(songName->getData());
}


void SongView1::paint( QPainter *p ) {
   QFont font = p->font();
   
   font.setBold( !(song->getPlayed()) );
   font.setItalic( song->getShufflePlay() );
   QFontMetrics fm(font);
   int ypos = fm.ascent() + fm.leading()/2;
   if (song->getCorrupt()) {
     p->setPen(QColor(red));
   }

   p->save();
   p->setFont(font);
   p->drawText( 5, ypos, text() );
   p->restore();   
}

int SongView1::height( const QListBox *lb ) const {
   return lb->fontMetrics().lineSpacing()+2;
}

int SongView1::width( const QListBox *lb ) const {
   return lb->fontMetrics().width( text() )+6;
}





