/*
  Configuration for the wavFileDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __WAVFILEDEVICECONFIG_H
#define __WAVFILEDEVICECONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <tag.h>
#include <song.h>
#include <qtimer.h>


class WavFileDeviceConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  bool lStopIsEOF_cfg;
  

 public:
   WavFileDeviceConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~WavFileDeviceConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();
   void updateEvent();

 public slots:
   void setCurrentFile(char* file);
   void setByteCounter(long bytecounter);
   int getStopIsEOF();
   const char* getDirectory();
   void update(int lupdate);

 private:

   QCheckBox* eofBox;
   QComboBox* dirEdit;
   QStrList* dirList;
   QTimer* updatePoll;
   
   QString counterString;
   QString filenameString;
   

   QLabel* counterLabel;
   QLabel* filenameLabel;
   
};
#endif
