/*
  Configuration for the mpg decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <mpgDecoderConfig.h>


MPGDecoderConfig::MPGDecoderConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  decoderID=Amplifier::createStandardDecoderID(_MP3_DECODER);

  load();
  
  QVBoxLayout *vbox3 = new QVBoxLayout(this, 5);


  infoBox= new QGroupBox(i18n("mpeg video decoder options"),this, "infoBox" );
  QVBoxLayout *vbox2 = new QVBoxLayout(infoBox, 5);
  vbox2->addSpacing( fontMetrics().height() );
 
  QWidget* w=new QWidget(infoBox);
  QVBoxLayout *vbox1 = new QVBoxLayout(w, 5);
  vbox1->addSpacing( fontMetrics().height() );

  downsampleBox=new QCheckBox(i18n("downsample"), w,"downsampleBox");
  downsampleBox->setChecked(downsample_cfg);

  monoBox=new QCheckBox(i18n("mono"), w,"monoBox");
  monoBox->setChecked(mono_cfg);

  calcLengthBox=new QCheckBox(i18n("calculate Length"), w,"calcLengthBox");
  calcLengthBox->setChecked(calcLength_cfg);

  syncBox=new QCheckBox(i18n("sync audio/video"), w,"syncBox");
  syncBox->setChecked(sync_cfg);

  downsampleBox->setFixedSize(downsampleBox->sizeHint());
  monoBox->setFixedSize(monoBox->sizeHint());
  calcLengthBox->setFixedSize(calcLengthBox->sizeHint());
  syncBox->setFixedSize(syncBox->sizeHint());


  vbox1->addWidget(downsampleBox,0,AlignLeft);
  vbox1->addWidget(monoBox,0,AlignLeft);
  vbox1->addWidget(calcLengthBox,0,AlignLeft);
  vbox1->addWidget(syncBox,0,AlignLeft);

  
  vbox2->addWidget(w,0,AlignLeft);
  vbox3->addWidget(infoBox,0,AlignLeft);

  QLabel* lineLabel1=new QLabel(this);
  lineLabel1->setText(i18n("simultated audio buffer size:"));
  lineLabel1->setFixedSize(lineLabel1->sizeHint());
  vbox3->addWidget(lineLabel1,0,AlignLeft);
  
  QLabel* lineLabel2=new QLabel(this);
  lineLabel2->setText(i18n("range: 0..307200 bytes [142400]"));
  lineLabel2->setFixedSize(lineLabel2->sizeHint());
  vbox3->addWidget(lineLabel2,0,AlignLeft);
 
  lineEdit= new QLineEdit (this );
  lineEdit->setFixedSize(QSize(300, 25));
  vbox3->addWidget(lineEdit,0,AlignLeft);
  QIntValidator* validator=new QIntValidator(0,307200,lineEdit);
  lineEdit->setValidator(validator);
  lineEdit->setText("142400");

  QPushButton* button=new QPushButton(i18n("restart decoder"),this);
  button->setFixedSize(button->sizeHint());
  vbox3->addWidget(button,0,AlignLeft);
 
  connect(button,SIGNAL(clicked()),SIGNAL(restart()));

  
}

MPGDecoderConfig::~MPGDecoderConfig() {
  delete decoderID;
}


const char* MPGDecoderConfig::getGroupName() {
  return "MPG";
}


void MPGDecoderConfig::load() {
  config->setGroup(configGroup);
  downsample_cfg=config->readBoolEntry( "downsample", false);
  mono_cfg=config->readBoolEntry( "mono", false);
  sync_cfg=config->readBoolEntry( "syncav", true);
  calcLength_cfg=config->readBoolEntry("calcLength",true);
}


void MPGDecoderConfig::save() {
  downsample_cfg=downsampleBox->isChecked();
  mono_cfg=monoBox->isChecked();
  calcLength_cfg=calcLengthBox->isChecked();
  sync_cfg=syncBox->isChecked();
    
  config->setGroup(configGroup);
  config->writeEntry( "downsample",downsample_cfg);
  config->writeEntry( "mono",mono_cfg);
  config->writeEntry( "syncav",sync_cfg);
  config->writeEntry( "calcLength",calcLength_cfg);
  

}


void MPGDecoderConfig::apply() {
  save();
  emit(restart());
}


int MPGDecoderConfig::canHandle(Song* song) {
  if (song->getDecoderType()==_EXTENSION_MPEG) {
    return true;
  }
  return false;
}


DecoderID* MPGDecoderConfig::getDecoderID() {
  delete decoderID;
  decoderID=Amplifier::createStandardDecoderID(_MPEG_VIDEO_DECODER);
  
  if (downsampleBox->isChecked()) {
    decoderID->addArgs("-2");
  }
  if (monoBox->isChecked()) {
    decoderID->addArgs("-m");
  }
  if (calcLengthBox->isChecked()==false) {
    decoderID->addArgs("-c");
  }
  if (syncBox->isChecked()==false) {
    decoderID->addArgs("-s");
  }
  const char* text=lineEdit->text();
  QString str;
  str += "-b ";
  str += text;
  decoderID->addArgs(str.data());
  return decoderID;
}

