/*
  Configuration for the audioDevice
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <splayDecoderConfig.h>


SplayDecoderConfig::SplayDecoderConfig(const char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  decoderID=Amplifier::createStandardDecoderID(_MP3_DECODER);

  load();
  
  QVBoxLayout *vbox3 = new QVBoxLayout(this, 5);


  infoBox= new QGroupBox(i18n("mp3 decoder options"),this, "infoBox" );
  QVBoxLayout *vbox2 = new QVBoxLayout(infoBox, 5);
  vbox2->addSpacing( fontMetrics().height() );
 
  QWidget* w=new QWidget(infoBox);
  QVBoxLayout *vbox1 = new QVBoxLayout(w, 5);
  vbox1->addSpacing( fontMetrics().height() );

  downsampleBox=new QCheckBox(i18n("downsample"), w,"downsampleBox");
  downsampleBox->setChecked(downsample_cfg);

  monoBox=new QCheckBox(i18n("mono"), w,"monoBox");
  monoBox->setChecked(mono_cfg);

  downsampleBox->setFixedSize(downsampleBox->sizeHint());
  monoBox->setFixedSize(monoBox->sizeHint());


  vbox1->addWidget(downsampleBox,0,AlignLeft);
  vbox1->addWidget(monoBox,0,AlignLeft);

  
  vbox2->addWidget(w,0,AlignLeft);
  vbox3->addWidget(infoBox,0,AlignLeft);

  
 

  QPushButton* button=new QPushButton(i18n("restart decoder"),this);
  button->setFixedSize(button->sizeHint());
  vbox3->addWidget(button,0,AlignLeft);
 
  connect(button,SIGNAL(clicked()),SIGNAL(restart()));

  
}

SplayDecoderConfig::~SplayDecoderConfig() {
  delete decoderID;
}


const char* SplayDecoderConfig::getGroupName() {
  return "splay";
}


void SplayDecoderConfig::load() {
  config->setGroup(configGroup);
  downsample_cfg=config->readBoolEntry( "downsample", false);
  mono_cfg=config->readBoolEntry( "mono", false);

}


void SplayDecoderConfig::save() {
  downsample_cfg=downsampleBox->isChecked();
  mono_cfg=monoBox->isChecked();
  config->setGroup(configGroup);
  config->writeEntry( "downsample",downsample_cfg);
  config->writeEntry( "mono",mono_cfg);

}


void SplayDecoderConfig::apply() {
  save();
  emit(restart());
}


int SplayDecoderConfig::canHandle(Song* song) {
  if (song->getDecoderType()==_EXTENSION_MP3) {
    return true;
  }
  return false;
}

DecoderID* SplayDecoderConfig::getDecoderID() {
  delete decoderID;
  decoderID=Amplifier::createStandardDecoderID(_MP3_DECODER);

  if (downsampleBox->isChecked()) {
    decoderID->addArgs("-2");
  }
  if (monoBox->isChecked()) {
    decoderID->addArgs("-m");
  }
    
  return decoderID;
}

