/*
  This defines the standard multimedia graph for the player.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <standardGraph.h>


StandardGraph::StandardGraph() {

  spectrumAnalyserDevice = new SpectrumAnalyserDevice();
  volumeDevice = new VolumeDevice();
  audioStreamBufferInfoDevice = new AudioStreamInfoDevice();
  audioStreamGeneralInfoDevice = new AudioStreamInfoDevice();
  audioStreamJumpInfoDevice = new AudioStreamInfoDevice();

  // Now we build the connection between them.
  // because we are a device we add them as our childs.

  addListener(spectrumAnalyserDevice);
  addListener(volumeDevice);
  addListener(audioStreamGeneralInfoDevice);
  addListener(audioStreamBufferInfoDevice);
  addListener(audioStreamJumpInfoDevice);

  // this device delivers message with "low" traffic:
  audioStreamGeneralInfoDevice->setEventMask(_AUDIOSTREAMINFO_STATUS_CHANGE |
					_AUDIOSTREAMINFO_MUSIC_CHANGE  |
					_AUDIOSTREAMINFO_AUDIO_CHANGE );

  // these devices are for the high traffic message, use with care
 audioStreamBufferInfoDevice->setEventMask(_AUDIOSTREAMINFO_BUFFERFILL_CHANGE);

  // the jumper needs its own device with its special eventmask
  audioStreamJumpInfoDevice->setEventMask(_AUDIOSTREAMINFO_TIME_CHANGE   |
				     _AUDIOSTREAMINFO_STATUS_CHANGE |
				     _AUDIOSTREAMINFO_MUSIC_CHANGE ); 

}


StandardGraph::~StandardGraph() {
  // Before you delete a player remove the listener

  delete spectrumAnalyserDevice;
  delete volumeDevice;
  delete audioStreamGeneralInfoDevice;
  delete audioStreamBufferInfoDevice;
  delete audioStreamJumpInfoDevice;
}

char* StandardGraph::getNodeName() {
  return "StandardGraph";
}


AudioStreamInfoDevice* StandardGraph::getGeneralInfoDevice() {
  return audioStreamGeneralInfoDevice;
}


AudioStreamInfoDevice* StandardGraph::getBufferInfoDevice() {
  return audioStreamBufferInfoDevice;
}


AudioStreamInfoDevice* StandardGraph::getJumpInfoDevice() {
  return audioStreamJumpInfoDevice;
}

VolumeDevice* StandardGraph::getVolumeDevice() {
  return volumeDevice;
}


SpectrumAnalyserDevice* StandardGraph::getSpectrumAnalyserDevice() {
  return spectrumAnalyserDevice;
}


  
void StandardGraph::writeIn(NodeDevice* source,DeviceConfig* config) {


  // now to our listeners
  // someone is writing to us.
  // forward it to connected listeners
  deliverToListener(config);


}



