
#include <kapp.h>
#include <amplifier/amplifier.h>
#include <devices/genericPlayer.h>
#include <devices/audioDevice.h>
#include <devices/esdDevice.h>
#include <deviceConfig/mem/garbageCollector.h>

#include <unistd.h>


/**
   This example programm show how the basics works.
   It creates first an Amplifier and an audioDevice.
   Then it connects everything and plays a song.


*/



int main(int nargs,char** args) {
  KApplication a( nargs, args);

  GarbageCollector::init();
  AudioDevice* audioDevice= new AudioDevice("/dev/dsp");
  //ESDDevice* audioDevice= new ESDDevice();
  GenericPlayer* player;
  if (audioDevice->open() == false) {
    cout << "cannot open audio"<<endl;
    exit(0);
  }


  if (nargs <= 1) {
    printf("Usage:\n\n");
    printf("%s filename\n\n",args[0]);
    exit(0);
  }

  player=Amplifier::createPlayer(_MP3_DECODER);
  //player=Amplifier::createPlayer(_WAV_DECODER);

  cout << "open file:"<<args[1]<<endl;
  player->open(args[1]);
  player->addListener(audioDevice);


  
  a.exec();

  delete player;
  delete audioDevice;
  
  return 0;
}



  
