/*
  swiches in intervalls between decoders
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <switcher.h>


Switcher::Switcher(){
  timer = new QTimer();
  decoders = new PtrArray();
  current=0;
  QObject::connect( timer, SIGNAL(timeout()), this, SLOT(timeEvent()) );
  msec=0;
  audioDevice=new AudioDevice("/dev/dsp");
  audioDevice->open();
}
 
Switcher::~Switcher() {
  int i;
  int n=decoders->getFillgrade();
  GenericPlayer* decoder;

  for(i=0;i<n;i++) {
    decoder=(GenericPlayer*)decoders->getPtrAt(i);
    delete decoder;
  }

  delete decoders;
  delete audioDevice;
}




void Switcher::add(GenericPlayer* decoder) {
  if (decoders->add(42,decoder) != true) {
    exit(-1);
  }
}

void Switcher::timeEvent() {
  GenericPlayer* nextDecoder=NULL;
  GenericPlayer* currentDecoder=NULL;

  int next=current+1;

  if (decoders->getFillgrade() <= 0) {
    cout << "no size"<<endl;
    return;
  }

  if (next == decoders->getFillgrade()) {
    next=0;
  }


  currentDecoder=(GenericPlayer*)decoders->getPtrAt(current);
  nextDecoder=(GenericPlayer*)decoders->getPtrAt(next);
  cout << "next decoder ######################decoder:"<<nextDecoder<<endl;

  currentDecoder->removeListener(audioDevice);
  cout << "after remove"<<endl;
  nextDecoder->addListener(audioDevice);

  current=next;
}
  


void Switcher::start(int msec) {
  this->msec=msec;
  timer->start(msec);
}


