/*
  prompts for an open file and opens it. Test for realtime handling
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <openTest.h>





OpenTest::OpenTest( QWidget *parent=0, 
			      const char *name=0 ): QWidget (parent,name) {
  
  genericPlayer=NULL;
}


OpenTest::~OpenTest() {
}



QSize OpenTest::sizeHint() const {
  QSize size(100,20);
  return size;
}


void OpenTest::buildGui() {
  layout = new QBoxLayout( this, QBoxLayout::LeftToRight, 1 );

  lineEdit=new QLineEdit(this);
  lineEdit->setMinimumSize( lineEdit->sizeHint() ); 
  layout->addWidget(lineEdit);
 

  openButton = new QPushButton(i18n("Open"), this ); 
  openButton->setMinimumSize( openButton->sizeHint() ); 
  connect(openButton , SIGNAL(clicked()), this, SLOT(open()));
  layout->addWidget(openButton);

}


void OpenTest::setText(const char* text) {
  lineEdit->validateAndSet(text,0,0,0);
}


int OpenTest::open() {
  int back=0;
  if (genericPlayer != NULL) {
    back=genericPlayer->open(lineEdit->text());
    cout << "open:"<<lineEdit->text()<<endl;
  }
  return back;
}


void OpenTest::attachTo(GenericPlayer* genericPlayer) {
  if (this->genericPlayer != NULL) {
    cout << "OpenTest already attached. call ignored!"<<endl;
    return;
  }
  this->genericPlayer=genericPlayer;
}


void OpenTest::detach() {
  genericPlayer=NULL;
}


