/*
  a basic player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef _PLAYER_H
#define _PLAYER_H


#include <qapp.h>
#include <qpushbt.h>
#include <qfont.h>
#include <qlayout.h>
#include <qradiobt.h>
#include <qbttngrp.h>
#include <qlistbox.h> 
#include <qmlined.h> 


#include <devices/audioDevice.h>
#include <amplifier/amplifier.h>

#include <guiTimerDevice.h>
#include <guiInfoDevice.h>
#include <guiControl.h>
#include <song.h>



class GuiPlayer : public QWidget {
  Q_OBJECT

  AudioStreamInfoDevice* audioStreamInfoDevice;
  AudioDevice* audioDevice;
  GenericPlayer* genericPlayer;
  QHBoxLayout* topLayout;

  GuiTimerDevice* guiTimerDevice;
  GuiControl* guiControl;
  GuiInfoDevice* guiInfoDevice;

  Song* currentSong;

 public:
  GuiPlayer();
  ~GuiPlayer();

 public slots:
  void setDeliverModus(int modus);
  void setNotifyMode(int modus);
  void wakeup();

 protected:
  void buildGui();

};

#endif


  
