/*
  a basic video player
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "videoPlayer.h"



VideoPlayer::VideoPlayer(QWidget *parent, const char *name) :
  QWidget(parent,name) { 
  
  genericPlayer=Amplifier::createPlayer(_IMAGE_VIEWER); 
  videoDevice = new VideoDevice();


  genericPlayer->addListener(videoDevice);



  topLayout=new QVBoxLayout(this);
  guiVideoDevice = new GuiVideoDevice(this);
  guiVideoDevice->attachTo(videoDevice);


  cout << "addWidget"<<endl;
  dropZone = new KDNDDropZone( this, DndURL );
  connect( dropZone, SIGNAL( dropAction( KDNDDropZone* )), SLOT( onDrop( KDNDDropZone*)));
  setBackgroundColor (QColor(0,0,0));
  buildGUI();
  topLayout->addWidget(guiVideoDevice);
 
}


VideoPlayer::~VideoPlayer() {
  // Every device in the tree must be deleted seperatley:

  delete genericPlayer;
  delete videoDevice;
  delete dropZone;
} 


void VideoPlayer::addListener(NodeDevice* listener) {
  genericPlayer->addListener(listener);
}


int VideoPlayer::open(KURL* url) {
  cout << "open:"<<url->path()<<endl;
  return genericPlayer->open((char*)url->path());
}


void VideoPlayer::jump(int percent) {
  cout << "jump:"<<percent<<endl;
  genericPlayer->jump(percent);
}


void VideoPlayer::buildGUI() {
  QLabel* label=new QLabel("drop a small xpm/gif in me",this);

  topLayout->addWidget(label);
  //   Set up the jump slider
  sb = new QSlider(QSlider::Horizontal, this);
  sb->setRange(0,100);
  sb->setValue( 0 );
  sb->setMinimumSize( 100,30 );
  sb->setMaximumSize( 100,30 );
  topLayout->addWidget(label);

  connect(sb,SIGNAL(valueChanged (int)),SLOT(jump(int)));

  cout << "buildGui"<<endl;
}  




void VideoPlayer::onDrop( KDNDDropZone* zone) {
  QStrList strlist;
  char *str;
  
  strlist = zone->getURLList();
  str=strlist.first(); 
  if (str != NULL) {
    KURL url( str );
    const char *path = url.path();
    open(&url);
    cout << "dropped:"<<path<<endl;
  }
}


