/*
  delays the audio pcm buffer
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __AUDIOBUFFERDAYSTREAMPRODUCER_H
#define __AUDIOBUFFERDAYSTREAMPRODUCER_H


#include <devices/streamProducer.h>
#include <util/ringBufferNT.h>
#include "bpmFilter.h"
#include <errno.h>



class AudioBufferDelayStreamProducer : public StreamProducer {

  RingBufferNT* ringBufferNT;
  MemChunk* insertMem;
  MemChunk* freeTest;
  DeviceConfig* deliverConfig;
  StreamProducer* producer;
  int lLock;
  char* cThreadPos;
  int maxLen;
  int lRun;
  int lThreadEnd;
  char* name;
  int locked;

 public:

  AudioBufferDelayStreamProducer(char* name);
  ~AudioBufferDelayStreamProducer();

  char* getNodeName();

  // Note: in a Streambuffer we have the Sender/Source of this buffer piece
  void writeIn(NodeDevice* source,DeviceConfig* buf);

  
  void writeloop();

 protected:
  void wakeUpThread(int lLockInProgress);

 private:

  void doDeliver();

  void lockDeliverThread();
  void unlockDeliverThread();
  
  void overflowTest();
  void underflowTest();

  pthread_mutex_t threadWriteInMut;
  pthread_mutex_t threadChangeMut;
  pthread_cond_t threadChangeCond;



};



#endif
