
#include <kapp.h>
#include <amplifier/amplifier.h>
#include <devices/mixerDevice.h>
#include <devices/audioDevice.h>
#include <deviceConfig/mem/garbageCollector.h>
#include <qpushbutton.h> 
#include <unistd.h>
#include "bpmDevice.h"

/**
   This example starts two decoders adds a mixer and a basic BPMDevice

   Make sure youe have edited the file

   ../SONGS.DEF


*/



#include "../SONGS.DEF"




int main(int nargs,char** args) {

  KApplication a( nargs, args);


  if (nargs <= 2) {
    printf("Usage:\n\n");
    printf("%s filename1.mp3 filename2.mp3\n\n",args[0]);
    exit(0);
  }

  cout << "open file:"<<args[1]<<endl;
  cout << "open file:"<<args[2]<<endl;
  GarbageCollector::init();
  cout << "create player1"<<endl;
  GenericPlayer* player1=Amplifier::createPlayer(_MP3_DECODER);
  cout << "create player2"<<endl;
  
  GenericPlayer* player2=Amplifier::createPlayer(_MP3_DECODER);
  cout << "create bpmDevice1"<<endl;

  BPMDevice* bpmDevice1=new BPMDevice("device1");
  cout << "create bpmDevice2"<<endl;
  BPMDevice* bpmDevice2=new BPMDevice("device2");


  bpmDevice1->setBPM(_BPM_HALF);
  bpmDevice2->setBPM(_BPM_DOUBLE);


 
  MixerDevice* mixerDevice=new MixerDevice();
  AudioDevice* audioDevice=new AudioDevice("/dev/dsp");
  
  cout << "mixerDevice addListener"<<endl;
  mixerDevice->addListener(audioDevice);
  cout << "player1 addListener"<<endl;
  player1->addListener(bpmDevice1);
  cout << "player2 addListener"<<endl;
  player2->addListener(bpmDevice2);
  
  
  cout << "bpmDevice1 addListener"<<endl;
  bpmDevice1->addListener(mixerDevice);
  cout << "bpmDevice2 addListener"<<endl;
  bpmDevice2->addListener(mixerDevice);
  

  if (audioDevice->open() == false) {
    cout << "cannot open audio"<<endl;
    exit(0);
  }
  player1->open(args[1]);
  player2->open(args[2]);
 
  QPushButton* b=new QPushButton("quit");
  b->setGeometry(100,100,100,30);
  QObject::connect(b,SIGNAL(clicked()),&a,SLOT(quit()));
  b->show();

  a.exec();
  

  cout << "shutdown start"<<endl;

  delete player1;
  delete player2;
  delete mixerDevice;
  delete audioDevice;
  cout << "clean shutdown"<<endl;


  return 0;
}



  
