/*
  show the frequence in the stream
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <guiFreqDevice.h>




GuiFreqDevice::GuiFreqDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  audioStreamInfoDevice=NULL;
}


GuiFreqDevice::~GuiFreqDevice() {
}


void GuiFreqDevice::attachTo(AudioStreamInfoDevice* audioStreamInfoDevice) {
  this->audioStreamInfoDevice=audioStreamInfoDevice;
  GuiDevice::attachTo(audioStreamInfoDevice);
  processEvent(_AUDIOSTREAMINFO_AUDIO_CHANGE);
}


void GuiFreqDevice::detach() {
  audioStreamInfoDevice=NULL;
  GuiDevice::detach();
}



void GuiFreqDevice::processEvent(char eventId) {
  if (eventId != _AUDIOSTREAMINFO_AUDIO_CHANGE) {
    return;
  }
  emit(setFreqEvent());
  repaint(false);
}


int GuiFreqDevice::getFreq() {
  if (audioStreamInfoDevice != NULL) {
    AudioInfo* audioInfo=audioStreamInfoDevice->getAudioInfo();
    return audioInfo->getSpeed();
  }
  return 0;
}


QSize GuiFreqDevice::sizeHint() const {
  return QSize(20,10);
}


void GuiFreqDevice::paintEvent ( QPaintEvent * paintEvent ) {
  int freq;
  QPainter paint;
  char txt[10];

  txt[9]=0;

  erase(0,0,width(),height());
  freq=getFreq();
  snprintf((char*)&txt,8,"%d",freq);
  paint.begin( this );
  paint.drawText(0,10,(char*)txt);
  paint.end();  

}
