/*
  gui part for the info device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __GUIINFODEVICE_H
#define __GUIINFODEVICE_H

#include <qpainter.h>
#include <qpushbt.h>


#include <yafcore/buffer.h>

#include <guiDevice.h>
#include <infoDeviceConfig.h>


/*
   Note: 
    The infoDecive only sends dataNotify if the data really
    has changed.
*/

class GuiInfoDevice : public GuiDevice {
  Q_OBJECT

  Song* currentSong;  
  Buffer* infoString;
  Preferences* preferences;
  struct InfoDeviceConfig* infoDeviceConfig;


 public:
  GuiInfoDevice( QWidget *parent=0, const char *name=0 );
  ~GuiInfoDevice();
  void setSong(Song* song);
  Song* getSong();

 public slots:
  void configure();
  void mousePressEvent ( QMouseEvent* mouseEvent);
  char* getInfoString();

  QSize sizeHint() const;
  void paintEvent ( QPaintEvent * paintEvent );
  void apply();  

 signals:
  void setSongEvent();
 
 private:
  char* getName();
  int getLen();
};


#endif
