/*
  radiobutton to select shuffle play
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <guiShuffle.h>


GuiShuffle::GuiShuffle(const char* text,QWidget *parent=0,const char *name=0):
    QCheckBox(text,parent,name) {

  connect(this,SIGNAL(toggled(bool)),this,SLOT(processShuffle(bool)));

}


GuiShuffle::~GuiShuffle() {
}


void GuiShuffle::processShuffle(bool lSet) {
  int val=(int)lSet;
  emit(setShuffleEvent(val));
}


void GuiShuffle::setShuffle(int lSet) {
  setChecked((bool)lSet);
}


QSize GuiShuffle::sizeHint() const {
  return QSize(20,10);
}
