/*
  abstract menu desription, which is used by popupMenus an menubars
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __MENUDESCRIPTION_H
#define __MENUDESCRIPTION_H

#include <iostream.h>
#include <qobject.h>
#include <kpopmenu.h>


/*
  This class make usage of the nice signal mechanism of qt.
  Each menu is descriped with:

  a titel
  an arbitary number of menuentries including the signal when selected.

*/

typedef struct {
  int valid;
  char* text;
  QObject* receiver;
  const char* signal;
} MenuEntry;


#define _MAX_MENU_ENTRIES    10

class MenuDescription {

  MenuEntry* menuEntryArray[_MAX_MENU_ENTRIES];
  const char* title;
  int elements;
  
 public:
  MenuDescription(const char* title);
  ~MenuDescription();

  char* getTitle();
  void setTitle(const char* title);

  void insertMenu(const char* text,QObject* receiver,const char* signal);

  
  int getElements();
  MenuEntry* getMenu(int pos);

  // the popup must be deleted by caller!
  KPopupMenu* createPopupMenu();

};


#endif
