/*
  The song class. An element in a modell.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <song.h>


Song::Song(char* aurl) {
  QString string(aurl);
  id3Tag=new Tag();
  mp3LayerInfo= new Layer();

  KURL::decodeURL(string);

  locationBuffer=new Buffer(20);
  locationBuffer->append(string.data());
  lPlayed=false;
  lShufflePlay=false;
  lCorrupt=false;
  KURL kurl(locationBuffer->getData());
  id3Tag->setFileName((char*)kurl.path());
  mp3LayerInfo->setFileName((char*)kurl.path());
  
  songUpdate();
  musicInfo=new MusicInfo();
  musicInfo->setName((char*)kurl.filename());
  musicInfo->setFileName((char*)kurl.path());
  int len=mp3LayerInfo->length();
  musicInfo->setLen(len);
}


Song::~Song() {
  delete locationBuffer;
  delete id3Tag;
  delete musicInfo;
  delete mp3LayerInfo;

}


void Song::setID3Tag(Tag* aId3Tag) {
  aId3Tag->copyTo(id3Tag);
}


void Song::setMusicInfo(MusicInfo* aInfo) {
  aInfo->copyTo(musicInfo);
}


Tag* Song::getID3Tag() {
  return id3Tag;
}


MusicInfo* Song::getMusicInfo() {
  return musicInfo;
}


Layer* Song::getMP3LayerInfo() {
  return mp3LayerInfo;
}


void Song::setMP3LayerInfo(Layer* aLayerInfo) {
  aLayerInfo->copyTo(mp3LayerInfo);
}

const char* Song::getSongLocation() {
  return locationBuffer->getData();
}



void Song::setPlayed(int lPlayed) {
  this->lPlayed=lPlayed;
  emit(songUpdateEvent(this));
}


int Song::getPlayed() {
  return lPlayed;
}


void Song::print() {
  cout << locationBuffer->getData()<<endl;
}


void Song::setShufflePlay(int lShufflePlay) {
  if (this->lShufflePlay != lShufflePlay) {
    this->lShufflePlay=lShufflePlay;
    emit(songUpdateEvent(this));
  }
}


int Song::getShufflePlay() {
  return lShufflePlay;
}


int Song::getCorrupt() {
  return lCorrupt;
}


void Song::setCorrupt(int lCorrupt) {
  this->lCorrupt=lCorrupt;
}


void Song::songUpdate() {
  id3Tag->load();
  mp3LayerInfo->load();
  emit(songUpdateEvent(this));
}


void Song::setSongLocation(const char* location) {
  locationBuffer->clear();
  locationBuffer->append(location);
}
  

void Song::copyTo(Song* dest) {
  if (dest == NULL) {
    cout << "song dest is NULL"<<endl;
    exit(0);
  }
  dest->setMusicInfo(getMusicInfo());
  dest->setCorrupt(getCorrupt());
  dest->setPlayed(getPlayed());
  dest->setShufflePlay(getShufflePlay());
  dest->setSongLocation(getSongLocation());
  dest->setID3Tag(getID3Tag());
  dest->setMP3LayerInfo(getMP3LayerInfo());
  dest->songUpdate();
}


int Song::getSongLength() {
  if (getDecoderType()==_EXTENSION_WAV) {
    const char* location=getSongLocation();
    KURL kurl(location);
    return WavFile::getLength((char*)kurl.path());
  }

  return mp3LayerInfo->length();
}
  

int Song::getDecoderType() {
  return Extension::getDecoderType(getSongLocation());
}

