/*
  The song class. An element in a modell.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __SONG_H
#define __SONG_H
	
#include <deviceConfig/info/musicInfo.h>
#include <tag.h>
#include <layer.h>

#include <kurl.h>
#include <qobject.h>
#include <qpainter.h>

#include <iostream.h>
#include <wavFile.h>
#include <amplifier/extension.h>
#include <stdio.h>


/**
   The url you set with setUrl is then owned by this class.
*/
	
class Song : public QObject{
 Q_OBJECT
 
   Buffer* locationBuffer;
   int lPlayed;
   Tag* id3Tag;
   MusicInfo* musicInfo;
   Layer* mp3LayerInfo;
   int lShufflePlay;
   int lCorrupt;

 public:
  Song(char* url);
  ~Song();

 public slots: 
  void setID3Tag(Tag* id3Tag);
  Tag* getID3Tag();

  void setMusicInfo(MusicInfo* musicInfo);
  MusicInfo* getMusicInfo();

  Layer* getMP3LayerInfo();
  void setMP3LayerInfo(Layer* mp3LayerInfo);

  const char* getSongLocation();
  void setSongLocation(const char* location);

  void setPlayed(int lPlayed);
  int getPlayed();

  void setShufflePlay(int lShufflePlay);
  int getShufflePlay();

  int getCorrupt();
  void setCorrupt(int lCorrupt);

  void print();
  void songUpdate();
  void copyTo(Song* dest);
  int getSongLength();
  int getDecoderType();

 signals:
  void songUpdateEvent(Song* song);
};
#endif




