/*
  Winamp Skin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "waSkin.h"


WaSkin::WaSkin(QWidget *parent=0, const char *name=0 ) 
  : GuiPlugin(parent,name) { 

  preferences=new Preferences();
  waSkinConfig=new WaSkinConfig("WaSkinConfig",preferences);
  preferences->addTab(waSkinConfig,waSkinConfig->getGroupName());
  connect(waSkinConfig,SIGNAL(applyEvent()),this,SLOT(apply()));

  waSkinConfigOption=new WaSkinConfigOption("WaSkinConfigOption",preferences);
  preferences->addTab(waSkinConfigOption,waSkinConfigOption->getGroupName());
  connect(waSkinConfigOption,SIGNAL(applyEvent()),this,SLOT(apply()));

  
  
  QString skinDir=waSkinConfig->getSkinPath();
  waSkinModell=new WaSkinModell();

  WaSkinOperation::loadSkinSet(skinDir,waSkinModell);


  createButtons();
  createHighLevelElements();
  sizeButtons();
  setMinimumSize(sizeHint());
  setMaximumSize(sizeHint());
}


WaSkin::~WaSkin() {
  delete preferences;
}


void WaSkin::attachTo(StandardGraph* standardGraph) {
   SpectrumAnalyserDevice* spectrumAnalyserDevice
                          =standardGraph->getSpectrumAnalyserDevice();
   AudioStreamInfoDevice* audioStreamJumpInfoDevice=
     standardGraph->getJumpInfoDevice();
   VolumeDevice* volumeDevice=standardGraph->getVolumeDevice();
   AudioStreamInfoDevice* audioStreamGeneralInfoDevice=
     standardGraph->getGeneralInfoDevice();

   guiSpectrumAnalyser->attachTo(spectrumAnalyserDevice);
   waJumpSlider->attachTo(audioStreamJumpInfoDevice);
   waVolumeSlider->attachTo(volumeDevice);
   waBalanceSlider->attachTo(volumeDevice);
   waDigit->attachTo(audioStreamJumpInfoDevice); 
   waBPS->attachTo(audioStreamGeneralInfoDevice);
   waFreq->attachTo(audioStreamGeneralInfoDevice);
   waInfo->attachTo(audioStreamGeneralInfoDevice);
   waStatus->attachTo(audioStreamGeneralInfoDevice);
   waStereo->attachTo(audioStreamGeneralInfoDevice);
   waMono->attachTo(audioStreamGeneralInfoDevice);
}


void WaSkin::detach() {
  guiSpectrumAnalyser->detach();
  waJumpSlider->detach();
  waVolumeSlider->detach();
  waBalanceSlider->detach();
  waDigit->detach();
  waBPS->detach();
  waFreq->detach();
  waInfo->detach();
  waStatus->detach();
  waStereo->detach();
  waMono->detach();
  
}


void WaSkin::setSong(Song* song) {
  waBPS->setSong(song);
  waInfo->setSong(song);
}




int  WaSkin::getSkinId() {
  return __SKINID_WINAMP;
}



QSize WaSkin::sizeHint() const {
  WaSkinDesc* waSkinDesc=waSkinModell->getWaSkinDesc(_WA_SKIN_MAIN);
  int w=waSkinDesc->getWidth();
  int h=waSkinDesc->getHeight();
  return QSize(w,h);
}


void WaSkin::paintEvent (QPaintEvent* paintEvent) {
  QPixmap* pixmapCurrent=waSkinModell->get(_WA_SKIN_MAIN);
  QPainter paint;
  paint.begin( this );
  paint.drawPixmap ( 0, 0, *pixmapCurrent);
  paint.end();  
}


void WaSkin::createButtons() {
  prev=new WaButton(waSkinModell,_WA_MAPPING_CBUTTONS_PREV,this);
  play=new WaButton(waSkinModell,_WA_MAPPING_CBUTTONS_PLAY,this);
  pause=new WaButton(waSkinModell,_WA_MAPPING_CBUTTONS_PAUSE,this);
  stop=new WaButton(waSkinModell,_WA_MAPPING_CBUTTONS_STOP,this);
  next=new WaButton(waSkinModell,_WA_MAPPING_CBUTTONS_NEXT,this);
  eject=new WaButton(waSkinModell,_WA_MAPPING_CBUTTONS_EJECT,this);
  shuffle=new WaButton(waSkinModell,_WA_MAPPING_SHUFFLE,this);
  repeat=new WaButton(waSkinModell,_WA_MAPPING_REPEAT,this);
  playlist=new WaButton(waSkinModell,_WA_MAPPING_PLAYLIST,this);
  eq=new WaButton(waSkinModell,_WA_MAPPING_EQ,this);

  shuffle->setToggleFlag(true);
  repeat->setToggleFlag(true);
  playlist->setToggleFlag(true);
  connect(shuffle,SIGNAL(setSelectedEvent(int)),
	  this,SIGNAL(shuffleClickedEvent(int)));
  
  connect(repeat,SIGNAL(setSelectedEvent(int)),
	  this,SIGNAL(repeatClickedEvent(int)));
		 
  connect(playlist,SIGNAL(setSelectedEvent(int)),
	  this,SIGNAL(playlistClickedEvent(int)));
		 

  
  prev->setPixmapUp(SIGNAL(event_WA_SKIN_CBUTTONS_PREV_NORM()),
                    _WA_SKIN_CBUTTONS_PREV_NORM);
  prev->setPixmapDown(SIGNAL(event_WA_SKIN_CBUTTONS_PREV_PRES()),
		      _WA_SKIN_CBUTTONS_PREV_PRES);
  connect(prev,SIGNAL(pressed()),this,SIGNAL(playPrevEvent()));

  play->setPixmapUp(SIGNAL(event_WA_SKIN_CBUTTONS_PLAY_NORM()),
                     _WA_SKIN_CBUTTONS_PLAY_NORM);
  play->setPixmapDown(SIGNAL(event_WA_SKIN_CBUTTONS_PLAY_PRES()),
		     _WA_SKIN_CBUTTONS_PLAY_PRES);
  connect(play,SIGNAL(pressed()),this,SIGNAL(playCurrentEvent()));


  
  
  pause->setPixmapUp(SIGNAL(event_WA_SKIN_CBUTTONS_PAUSE_NORM()),
                    _WA_SKIN_CBUTTONS_PAUSE_NORM);
  pause->setPixmapDown(SIGNAL(event_WA_SKIN_CBUTTONS_PAUSE_PRES()),
		      _WA_SKIN_CBUTTONS_PAUSE_PRES);
  connect(pause,SIGNAL(pressed()),this,SIGNAL(playPauseEvent()));



  stop->setPixmapUp(SIGNAL(event_WA_SKIN_CBUTTONS_STOP_NORM()),
                    _WA_SKIN_CBUTTONS_STOP_NORM);
  stop->setPixmapDown(SIGNAL(event_WA_SKIN_CBUTTONS_STOP_PRES()),
		      _WA_SKIN_CBUTTONS_STOP_PRES);
  connect(stop,SIGNAL(pressed()),this,SIGNAL(playStopEvent()));



  next->setPixmapUp(SIGNAL(event_WA_SKIN_CBUTTONS_NEXT_NORM()),
                    _WA_SKIN_CBUTTONS_NEXT_NORM);
  next->setPixmapDown(SIGNAL(event_WA_SKIN_CBUTTONS_NEXT_PRES()),
		     _WA_SKIN_CBUTTONS_NEXT_PRES);
  connect(next,SIGNAL(pressed()),this,SIGNAL(playNextEvent()));


  eject->setPixmapUp(SIGNAL(event_WA_SKIN_CBUTTONS_EJECT_NORM()),
                    _WA_SKIN_CBUTTONS_EJECT_NORM);
  eject->setPixmapDown(SIGNAL(event_WA_SKIN_CBUTTONS_EJECT_PRESS()),
		      _WA_SKIN_CBUTTONS_EJECT_PRESS);
  connect(next,SIGNAL(pressed()),this,SIGNAL(ejectEvent()));



  shuffle->setPixmapUp(SIGNAL(event_WA_SKIN_SHUFREP_SHUFFLE_NOT_SET_NORM()),
		       _WA_SKIN_SHUFREP_SHUFFLE_NOT_SET_NORM);
  shuffle->setPixmapDown(SIGNAL(event_WA_SKIN_SHUFREP_SHUFFLE_NOT_SET_PRES()),
		     _WA_SKIN_SHUFREP_SHUFFLE_NOT_SET_PRES);
  shuffle->setPixmapUpSelected(
           SIGNAL(event_WA_SKIN_SHUFREP_SHUFFLE_SET_NORM()),
	   _WA_SKIN_SHUFREP_SHUFFLE_SET_NORM);
  shuffle->setPixmapDownSelected(
	   SIGNAL(event_WA_SKIN_SHUFREP_SHUFFLE_SET_PRES()),
	   _WA_SKIN_SHUFREP_SHUFFLE_SET_PRES);
  shuffle->setSelected(true);

  repeat->setPixmapUp(SIGNAL(event_WA_SKIN_SHUFREP_REPEAT_NOT_SET_NORM()),
                     _WA_SKIN_SHUFREP_REPEAT_NOT_SET_NORM);
  repeat->setPixmapDown(SIGNAL(event_WA_SKIN_SHUFREP_REPEAT_NOT_SET_PRES()),
		     _WA_SKIN_SHUFREP_REPEAT_NOT_SET_PRES );
  repeat->setPixmapUpSelected(
          SIGNAL(event_WA_SKIN_SHUFREP_REPEAT_SET_NORM()),
          _WA_SKIN_SHUFREP_REPEAT_SET_NORM);
  repeat->setPixmapDownSelected(
          SIGNAL(event_WA_SKIN_SHUFREP_REPEAT_SET_PRES()),
	  _WA_SKIN_SHUFREP_REPEAT_SET_PRES );


  eq->setPixmapUp(SIGNAL(event_WA_SKIN_SHUFREP_EQ_NOT_SET_NORM()),
		  _WA_SKIN_SHUFREP_EQ_NOT_SET_NORM);
  eq->setPixmapDown(SIGNAL(event_WA_SKIN_SHUFREP_EQ_NOT_SET_PRES()),
		    _WA_SKIN_SHUFREP_EQ_NOT_SET_PRES );

  

  playlist->setPixmapUp(SIGNAL(event_WA_SKIN_SHUFREP_PLAYLIST_NOT_SET_NORM()),
			_WA_SKIN_SHUFREP_PLAYLIST_NOT_SET_NORM);
 playlist->setPixmapDown(SIGNAL(event_WA_SKIN_SHUFREP_PLAYLIST_NOT_SET_PRES())
			 ,_WA_SKIN_SHUFREP_PLAYLIST_NOT_SET_PRES);

  playlist->setPixmapUpSelected(
	    SIGNAL(event_WA_SKIN_SHUFREP_PLAYLIST_SET_NORM()),
	    _WA_SKIN_SHUFREP_PLAYLIST_SET_NORM);
 playlist->setPixmapDownSelected(
	    SIGNAL(event_WA_SKIN_SHUFREP_PLAYLIST_SET_PRES())
	    ,_WA_SKIN_SHUFREP_PLAYLIST_SET_PRES);
  
}



void WaSkin::sizeButtons() {
  prev->setFixedSize(prev->sizeHint());
  play->setFixedSize(play->sizeHint());
  pause->setFixedSize(pause->sizeHint());
  stop->setFixedSize(stop->sizeHint());
  next->setFixedSize(next->sizeHint());
  eject->setFixedSize(eject->sizeHint());
  shuffle->setFixedSize(shuffle->sizeHint());
  repeat->setFixedSize(repeat->sizeHint());
  playlist->setFixedSize(playlist->sizeHint());
  eq->setFixedSize(eq->sizeHint());

}




void WaSkin::createHighLevelElements() {
  WaSkinDesc* waSkinDesc;
  guiSpectrumAnalyser = new GuiSpectrumAnalyser(this);
  waSkinDesc=waSkinModell->getWaSkinMapDesc(_WA_MAPPING_ANALYSER);
  guiSpectrumAnalyser->setGeometry((*waSkinDesc->getGeometry()));

  waJumpSlider= new WaJumpSlider(waSkinModell,this);
  waJumpSlider->buildGui();
  waJumpSlider->setFixedSize(waJumpSlider->sizeHint());


  waVolumeSlider= new WaVolumeSlider(waSkinModell,this);
  waVolumeSlider->buildGui();
  waVolumeSlider->setFixedSize(waVolumeSlider->sizeHint());

  waBalanceSlider= new WaBalanceSlider(waSkinModell,this);
  waBalanceSlider->buildGui();
  waBalanceSlider->setFixedSize(waBalanceSlider->sizeHint());

  waDigit= new WaDigit(waSkinModell,this);
  waDigit->setFixedSize(waDigit->sizeHint());


  waBPS= new WaBPS(waSkinModell,this);
  waBPS->setFixedSize(waBPS->sizeHint());

  waFreq= new WaFreq(waSkinModell,this);
  waFreq->setFixedSize(waFreq->sizeHint());

  waInfo= new WaInfo(waSkinModell,this);
  waInfo->setFixedSize(waInfo->sizeHint());

  waStatus= new WaStatus(waSkinModell,this);
  waStatus->setFixedSize(waStatus->sizeHint());

  waStereo= new WaStereo(waSkinModell,this);
  waStereo->setFixedSize(waStereo->sizeHint());

  waMono= new WaMono(waSkinModell,this);
  waMono->setFixedSize(waMono->sizeHint());

 connect(waJumpSlider,SIGNAL(jump(int)),this,SIGNAL(jump(int)));
  // now a few connections to the modell
  connect(waSkinModell,SIGNAL(event_WA_SKIN_MAIN()),
	  this,SLOT(pixmapChange()));

}


void WaSkin::configure() {
  preferences->show();
}

void WaSkin::apply() {
  QString skinDir1=waSkinConfig->getSkinPath();
  QString skinDir2=waSkinModell->getSkinDirectory();

  
  if (skinDir1 != skinDir2) {
    WaSkinOperation::loadSkinSet(skinDir1,waSkinModell);
  }
}


void WaSkin::pixmapChange() {
  repaint(false);
}




void WaSkin::setRepeat(int val) {
  repeat->setSelected(val);
}


void WaSkin::setShuffle(int val) {
  shuffle->setSelected(val);
}


void WaSkin::setPlaylist(int val) {
  playlist->setSelected(val);
}

  
