/*
  reads input data
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

#ifndef  __BUFFERINPUTSTREAM_H
#define  __BUFFERINPUTSTREAM_H

#include "simpleRingBuffer.h"
#include "inputStream.h"

class BufferInputStream : public InputStream {

  SimpleRingBuffer* ringBuffer;
  int leof;
  char* name;
  long bytePos;
  int fillgrade;
  pthread_mutex_t writeInMut;
  pthread_mutex_t changeMut;
  pthread_cond_t changeCond;


 public:
  BufferInputStream(int size,int minlinSize,char* name);
  ~BufferInputStream();

  int open(char* name);
  void close();

  int eof();
  void setEof(int leof);
  int read(char* ptr,int size);
  int write(char* ptr,int elements);

  int seek(long bytePos);


  long getByteLength();
  long getBytePosition();

  void setBytePosition(long bytePos);
  int getFillgrade();
  int getFreeRead();
  int getFreeWrite();

  void clear();

  void insertTimeStamp(TimeStamp* src,int len);

  // remote read extension
  int readRemote(char* &ptr,int size);
  void forwardReadPtr(int bytes);
  void setCanWaitForData(int lBlock);

 private:
  void lockBuffer();
  void unlockBuffer();
 

};
#endif
