/*
  mpg I video/audio player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "mpegLength.h"


#define SEARCH_SIZE 1024*1024*6
#define SEEKWINDOW  1024*1024

MpegLength::MpegLength(InputStream* input) {


  this->input=input;

  timeCodeStart=new TimeCode();
  timeCodeEnd=new TimeCode();
  timeCodeLength=new TimeCode();
 
}


MpegLength::~MpegLength() {
  delete timeCodeStart;
  delete timeCodeEnd;
  delete timeCodeLength;
}



long MpegLength::getLength() {
  // length in second
  long back=0;
  back=timeCodeLength->getHour()*60*60;
  back+=timeCodeLength->getMinute()*60;
  back+=timeCodeLength->getSeconds();
  return back;
}


long MpegLength::getSeekPos(int seconds) {
  // calculate from seconds to predicted position in stream
  long byteLength=input->getByteLength();
  long back=0;
  float ratio;

  ratio=(float)byteLength*(float)seconds;
  ratio=ratio/((float)getLength()+1.0);
  back=(long)ratio;

  return back;
    
}



void MpegLength::readTimeCode(TimeCode* timeCode,MpegPlayBitWindow* bitwindow){
  unsigned int data;

  /* Flush group of pictures start code. */
  bitwindow->flushBits(32);

  /* Parse off drop frame flag. */
  data=bitwindow->getBits(1);

  /* Parse off hour component of time code. */

  data=bitwindow->getBits(5);
  timeCode->setHour(data);

  /* Parse off minute component of time code. */

  data=bitwindow->getBits(6);
  timeCode->setMinute(data);

  /* Flush marker bit. */
  bitwindow->flushBits(1);

  /* Parse off second component of time code. */

  data=bitwindow->getBits(6);
  timeCode->setSeconds(data);
  
}



int MpegLength::seekValue(unsigned int code,MpegPlayBitWindow* bitwindow,
			  long& valueSeeked) {
  unsigned int data;
  long start=input->getBytePosition();
  long cnt=0;
  long end=start+SEEKWINDOW;
  long area=0;

  // if we have not enought space we skip
  // because auf the mpeg frame garbage "mb_stuffing,etc..."

  if (end > input->getByteLength()-SEEKWINDOW){
    valueSeeked=SEEKWINDOW;
    return false;
  }
  area=end-start;

  data=bitwindow->showBits(32);
  while (data != code) {
    bitwindow->flushBitsDirect(8);
    data=bitwindow->showBits(32);
    cnt++;
    if (cnt >= area) {
      valueSeeked=cnt;
      return false;
    }
  }

  return true;
}


// We try to search the first SEARCH_SIZE KB for a valid picture start.
int MpegLength::seekToStart() {
  int success;

  success=input->seek(0);
  if (success == false) {
    cout << "inputStream does not support seek"<<endl;
    return false;
  }

  MpegPlayBitWindow* bitwindow=new MpegPlayBitWindow(input);
  if (bitwindow->firstSync()==false) {
    cout << "no sync found start"<<endl;
    delete bitwindow;
    return false;
  }
  bitwindow->hasBytes(100);

  success=parseToGOP(timeCodeStart,bitwindow);
  delete bitwindow;

  if (success == false) {
    cout << "picture startcode not found"<<endl;
    return false;
  }

  return true;
}



int MpegLength::seekToEnd() {
  int success;
  long lengthOfStream;

  lengthOfStream=input->getByteLength();
  if (lengthOfStream < SEARCH_SIZE) {
    cout << "stream to short"<<endl;
    return false;
  }
  
  if (lengthOfStream > 1024*1024*600) {
    cout << "urgh! file too long, we don not jump that wide"<<endl;
    cout << "using 600 MB"<<endl;
    lengthOfStream=1024*1024*600;
  }
  success=input->seek(lengthOfStream-SEARCH_SIZE);
  if (success == false) {
    cout << "inputStream does not support seek"<<endl;
    return false;
  }

  MpegPlayBitWindow* bitwindow=new MpegPlayBitWindow(input);
  if (bitwindow->firstSync()==false) {
    cout << "no sync found end"<<endl;
    delete bitwindow;
    return false;
  }
  bitwindow->hasBytes(100);
  success=parseToGOP(timeCodeEnd,bitwindow);
  delete bitwindow;

  if (success == false) {
    cout << "picture endcode not found"<<endl;
    return false;
  }

  return true;
}


int MpegLength::parseToGOP(TimeCode* dest,MpegPlayBitWindow* bitwindow) {
  int success;
  // we try ten attempts
  // and the diff between each must be (less) than one second

  int successCnt=0;

  int pos=input->getBytePosition();
  long maxArea=0;
  long area=0;

  TimeCode lastTime;
  TimeCode currentTime;
  TimeCode diffTime;


  while(successCnt < 4) {
    if (bitwindow->isEof()) {
      return false;
    }
    if (input->eof() == true) {
      cout << "abort"<<endl;
      return false;
    }
    if (maxArea > SEARCH_SIZE) {
      return false;
    }

    bitwindow->flushByteOffset();
    /*
    success=seekValue(SEQ_START_CODE,bitwindow,area);
    maxArea+=area;

    if (success == false) {
      continue;
    }
    */
    success=seekValue(GOP_START_CODE,bitwindow,area);
    maxArea+=area;
    
    if (success == false) {
      continue;
    }
    successCnt++;
    readTimeCode(&currentTime,bitwindow);
    diffTime.substract(&currentTime,&lastTime);
    currentTime.copyTo(&lastTime);

    if (diffTime.getHour() != 0) {
      successCnt=0;
      continue;
    }
    if (diffTime.getMinute() != 0) {
      successCnt=0;
      continue;
    }
    if (diffTime.getSeconds() > 8) {
      successCnt=0;
      continue;
    }   
    
  }
  lastTime.copyTo(dest);
  return true;
}





void MpegLength::startCalc() {
  int currentPos=input->getBytePosition();
  int lContinue=true;
  if (input->getByteLength() <= SEARCH_SIZE) {
    cout << "file too short for time detections"<<endl;
    cout << "byteLength:"<<input->getByteLength()<<endl;
    cout << "required size:"<<SEARCH_SIZE<<endl;
    lContinue=false;
  }
  

  if (lContinue==true) {
    if (seekToStart()==false) {
      lContinue=false;
    }
  }
  if (lContinue==true) {
    if (seekToEnd()==false) {
      lContinue=false;
    }
  }  

  if (lContinue==true) {
    timeCodeLength->substract(timeCodeEnd,timeCodeStart);
  }  
  input->seek(currentPos);
  timeCodeLength->print("length");
}



