/*
  a bitwindow buffer
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "mpegPlayBitWindow.h"

#define _BYTE_TEST 1024


MpegPlayBitWindow::MpegPlayBitWindow(InputStream* input) {


  // Make buffer length multiple of 4. 

  this->size=80000;
  this->input=input;
  packet=new Packet();

  if ((size % 4) != 0) {
    cout << "MpegPlayBitWindow not multiple of 4"<<endl;
    exit(-1);
  }

  /* Create MpegPlayBitWindow. */
  buf_start = new (unsigned int)[size*4];
  
  /*
   * Set max_buf_length to one less than actual length to deal with messy
   * data without proper seq. end codes.
   */
  max_buf_length=size-1;


  /* Initialize bitstream i/o fields. */

  bit_offset = 0;
  buffer = buf_start;
  buf_length = 0;
  num_left=0;
  leftover_bytes=0;
  curBits = 0;
 
}


MpegPlayBitWindow::~MpegPlayBitWindow() {
  delete packet;
}


void MpegPlayBitWindow::clear() {
  buffer = buf_start;
  buf_length = 0;
  bit_offset = 0;
}



void MpegPlayBitWindow::setLength(int len) {
  buf_length = len;
}


int MpegPlayBitWindow::getLength() {
  return buf_length;
}


void MpegPlayBitWindow::setCurrentValue(int value){
  *buffer = value;
}

int MpegPlayBitWindow::hasBytes(int byteCnt) {
  if (buf_length < byteCnt) {
    get_more_video_data();
  }    
  if (buf_length < byteCnt) {
    return hasBytes(byteCnt);
  }
  return true;
}

void MpegPlayBitWindow::flushBits(int bits) {
                                                                      
  hasBytes(_BYTE_TEST);
                                                                      
  flushBitsDirect(bits);
}


int MpegPlayBitWindow::showBits(int bits) {
  int mask=nBitMask[bits];
  int shift=32-(bits);
  int bO;                                                               
                                                                        
  hasBytes(_BYTE_TEST);
 
  shift=(curBits & mask)>>shift;
  bO = bit_offset + bits;                                    
  if (bO > 32) {                                                        
    return (shift | (*(buffer+1)>>(64-bO)));
  }                                                                     
  return shift;                   
}




int MpegPlayBitWindow::getBits(int bits) {
  int result=showBits(bits);
  flushBits(bits);
  return result;
}


void MpegPlayBitWindow::printChar(int bytes) {
  int i;
  unsigned char* mark;

  mark=(unsigned char *)buffer;

  for(i=0;i<bytes;i++) {
    printf("i:%d read=%x\n",i,mark[i]);
  }
  printf("*********\n");

}


void MpegPlayBitWindow::printInt(int bytes) {
  int i;
  int n;
  unsigned int* mark;
  
  mark=(unsigned int*)buf_start;

  n=bytes/sizeof(int);
  for(i=0;i<n;i++) {
    printf("i:%d read=%x\n",i,mark[i]);
  }
  printf("*********\n");

}


int MpegPlayBitWindow::isEof() {
  if (input->eof()) {
    cout << "reader is eof"<<endl;
    cout << "getLength:"<<getLength()<<endl;
    return true;
  }
  return false;
}



void MpegPlayBitWindow::resetBuffer() {
  /* Initialize bitstream i/o fields. */
  bit_offset = buf_length = 0;
  buffer = buf_start;
  curBits = 0;

}

void MpegPlayBitWindow::updateCurBits() {
  curBits = *buffer << bit_offset;
}


void MpegPlayBitWindow::flushByteOffset() {
  int byteoff;
  hasBytes(_BYTE_TEST);
  
  byteoff = bit_offset % 8;

  if (byteoff != 0) {
    flushBits((8-byteoff));
  }

}
 

void MpegPlayBitWindow::print() {
  printf("bit_offset:%x\n",bit_offset);
  printf("num_left:%x\n",num_left);
  printf("leftover_bytes:%x\n",leftover_bytes);
  printf("buf_length:%x\n",buf_length);
  printf("curBits:%x\n",curBits);
  printChar(8);
}




void MpegPlayBitWindow::fillWithIsoEndCode(int bytes) {
  int i;
  int n=bytes/4;
  cout << "fillWithIsoEndCode -1"<<endl;
  for (i=0;i<n;i++) {
    appendToBuffer(ISO_11172_END_CODE);
  }
}

void MpegPlayBitWindow::appendToBuffer(unsigned int startCode) {
  unsigned int startCodeRaw=htonl(startCode);
  resizeBuffer(4);
  appendToBuffer((unsigned char*)&startCodeRaw,4);
}


int MpegPlayBitWindow::appendToBuffer(unsigned char* ptr,int len) {
  int byte_length = getLength()*4;


  resizeBuffer(len);
  
  if (num_left != 0) {
    byte_length += num_left;
    *(buffer+buf_length)=leftover_bytes;
  }
  memcpy(((unsigned char *)buffer)+byte_length,ptr,len);
  
  if (1 != ntohl(1)) {
    unsigned int *mark = buffer+buf_length;
    int i;
    int n=(len+num_left)&0xfffffffc;
    for (i=0; i < n; i+=4) {
      *mark=ntohl(*mark);
      mark++;
    }
  }

  byte_length = byte_length + len;
  num_left = byte_length % 4;
  buf_length = byte_length / 4;
  updateCurBits();

  leftover_bytes = *(buffer +buf_length);
  return true;
}


void MpegPlayBitWindow::resizeBuffer(int insertBytes) {
  /* Read all the headers, now make room for packet */
  if (buf_start+max_buf_length < buffer+insertBytes/4+buf_length) {

    if (max_buf_length - buf_length < (int) insertBytes/4) {

      /* Buffer too small for a packet (plus whats there), 
       * time to enlarge it! 
       */
      cout << "enlarge buffer-1*********** insertBytes"<<insertBytes<<endl;
      unsigned int *old = buf_start;
      max_buf_length=buf_length+insertBytes/4+1;
      cout << "allocating :"<<max_buf_length<<endl;
      buf_start=new (unsigned int)[max_buf_length];
      if (buf_start == NULL) {
	cout << "allocation of:"<<max_buf_length<<" bytes failed"<<endl;
	exit(0);
      }
      memcpy((unsigned char *)buf_start,buffer,(unsigned int)buf_length*4);
      delete old;
      buffer = buf_start;
      cout << "enlarge buffer-1 end***********"<<endl;

    } else {
      memcpy((unsigned char *)buf_start,
	     buffer, (unsigned int) buf_length*4);
      buffer = buf_start;
    }
  }
}

int MpegPlayBitWindow::getLinearFree() {
  unsigned int* endPos=buf_start+size;
  unsigned int* currPos=buffer+buf_length;
  
  int back=endPos-currPos;
  return back;
}


int MpegPlayBitWindow::getSize() {
  return size;
}


int MpegPlayBitWindow::getFreeBytes() {
  return ((size-getLength())*4);
}


int MpegPlayBitWindow::getLayer() {
  return packet->getSysLayer();
}


int MpegPlayBitWindow::firstSync() {

  unsigned int startCode;
  cout << "syncStream firstSync"<<endl;
  clear();
  if (packet->syncStream(startCode,input)==false) {
    cout << "no sync insert iso endcode "<<endl;
    return false;
  }


  int layer=packet->getSysLayer();
  if (input->eof()) {
    fillWithIsoEndCode(getFreeBytes());
    cout << "input->eof fill iso end"<<endl;
    return true;
  }
  if (layer == _PACKET_UNKNOWN_LAYER) {
    cout << "no layer found"<<endl;
    exit(0);
  }
  if (layer == _PACKET_NO_SYSLAYER) {
    // insert everything into videoplayer
    appendToBuffer(startCode);
  }
  return true;
}

int MpegPlayBitWindow::get_more_video_data() {
  int bytes=0;
  unsigned char packetID;
  int layer=getLayer();

  bytes=0;
  // do init or normal read
  if (layer == _PACKET_SYSLAYER) {
    bytes=packet->readNextLayer(packetID,input);
  } else {
    bytes=0x8000;
    packetID=PAKET_ID_VIDEO;
  }

  if (bytes  < 0) {
    printf ("\n");
    fillWithIsoEndCode(1024);
    perror("Unexpected read error.");
    return false;
  }

  unsigned char* packetBuffer= new unsigned char[bytes];
  int didRead;
  didRead=input->read((char*)packetBuffer,bytes);
  if (bytes==0) {
    fillWithIsoEndCode(1024);
    return true;
  }

  if (packetID==PAKET_ID_VIDEO) {
    appendToBuffer(packetBuffer,didRead);
    if (input->eof()) {
      fillWithIsoEndCode(bytes-didRead);
    }
  } else {
    // audio
    //FILE* file=fopen("a.mpeg","a");
    //fwrite(packetBuffer,1,bytes,file);
    //fclose(file);
  }
  delete packetBuffer;
  return true;
}


TimeStamp* MpegPlayBitWindow::getCurrentTimeStamp() {
  long pos=input->getBytePosition();
  int transfered=4*getLength();
  pos=pos-transfered;

  TimeStamp* timeStamp=input->getTimeStamp(pos);

  return timeStamp;
}

