/*
  encapsulates the syncing methods, to use it in other classes
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __AVSYNCER_H
#define __AVSYNCER_H

#include <stdlib.h>
#include "audioDataArray.h"
#include "picture.h"

class AVSyncer {

  AudioData* audioDataInsert;
  AudioData* audioDataCurrent;
  AudioDataArray* audioDataArray;

  AudioTime* audioTime;
  int onePicFrameInAudioBytes;
  int oneFrameTime;

  int lAudioRunning;

  pthread_mutex_t writeInMut;
  pthread_mutex_t changeMut;
  pthread_cond_t changeCond;

  int bufferSize;

  TimeStamp* startAudio;
  TimeStamp* endAudio;



 public:
  AVSyncer(int bufferSize);
  ~AVSyncer();

  // audio
  int audioSetup(int frequency,int stereo,int sign,int big,int sixteen);
  int audioPlay(TimeStamp* startStamp,
		TimeStamp* endStamp,char *buffer, int size);
  void audioClose(void);
  void audioFlush();

  int getPreferredDeliverSize();

  // video
  int getFrameusec();
  

  void config(char* key, char* value);

  // methods which belong not to the OutputStream interface
  int avSync(TimeStamp* startVideoStamp,
	     TimeStamp* endVideoStamp,TimeStamp* waitTime,
	     Picture* pic);

  int getAudioRunning();
  void setAudioRunning(int lAudioRunning);

 private:
  void lockSyncData();
  void unlockSyncData();
  void setAudioSync(AudioData* audioData);
 
 
};
#endif
