/*
  concret OutputClass
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "dspX11OutputStream.h"



DspX11OutputStream::DspX11OutputStream(int bufferSize) {
  audioWrapper=new AudioWrapper();
  x11Window=new X11Window(true);
  avSyncer=new AVSyncer(bufferSize);

  videoTimeStamp=new TimeStamp();
  waitTime=new TimeStamp();
  diffTime=new TimeStamp();
  audioTime=new AudioTime();


  lneedInit=false;
  lVideoInit=false;
  lavSync=true;
}


DspX11OutputStream::~DspX11OutputStream() {
  delete audioWrapper;
  delete x11Window;
  delete videoTimeStamp;
  delete waitTime;
  delete diffTime;
  delete avSyncer;
}



int DspX11OutputStream::audioSetup(int frequency,int stereo,
				   int sign,int big,int sixteen) {

  if (audioWrapper->isOpenDevice() == false) {
    audioWrapper->openDevice();
  }
  audioWrapper->init(sixteen,frequency,stereo);
  audioTime->setFormat(stereo,sixteen,frequency);
  avSyncer->audioSetup(frequency,stereo,sign,big,sixteen);

  return true;
}


void DspX11OutputStream::audioClose(void) {
  avSyncer->audioClose();
  audioWrapper->closeDevice();
}


void DspX11OutputStream::audioFlush() {
  avSyncer->audioFlush();
}


int DspX11OutputStream::audioPlay(TimeStamp* startStamp,
				  TimeStamp* endStamp,char *buffer, int size) {

  int len;
  

  if (lneedInit) {
    audioWrapper->init(audioTime->getSampleSize(),
		       audioTime->getSpeed(),
		       audioTime->getStereo());   
    lneedInit=false;
  }


  avSyncer->audioPlay(startStamp,endStamp,buffer,size);
  len=audioWrapper->write(buffer,size);



  
 
  if (len != size) {
    lneedInit=true;
  }
  return len;
}


int DspX11OutputStream::getPreferredDeliverSize() {
  return avSyncer->getPreferredDeliverSize();
}


int DspX11OutputStream::openWindow(int width, int height,char *title) {
  int back=x11Window->openWindow(width,height,title);
  setOutputInit(true);
  return back;
}


void DspX11OutputStream::closeWindow() {
  x11Window->closeWindow();
}

void DspX11OutputStream::flushWindow() {
  x11Window->flushWindow();
}


void DspX11OutputStream::putImage(TimeStamp* startStamp,
				  TimeStamp* endStamp,struct Picture* pic){

  float picPerSec=pic->getPicturePerSecond();
  int oneFrameTime=0;

  if (picPerSec > 0) {
    oneFrameTime=(int) (1000000.0/picPerSec);
  }

  int lpacketSync=true;

  videoTimeStamp->gettimeofday();
  diffTime->minus(videoTimeStamp,videoTimeStamp);

  if (lavSync==false) {
    if (videoTimeStamp->isNegative()) {
      diffTime->gettimeofday();
      diffTime->addOffset(0,oneFrameTime);
      cout << "skip time based"<<endl;
      return;
    }
  }


  videoTimeStamp->copyTo(waitTime);

  if (lavSync) {
    lpacketSync=avSyncer->avSync(startStamp,endStamp,waitTime,pic);
  } 


  if (lpacketSync == false) {
    //cout << "skip"<<endl;
    diffTime->gettimeofday();
    diffTime->addOffset(0,oneFrameTime);
    return;
  }


  x11Window->putImage(pic,waitTime);

  if (lavSync) {
     waitTime->minus(videoTimeStamp,waitTime);
     if (waitTime->isPositive()) {
       diffTime->addOffset(waitTime);
     }
  }

  diffTime->addOffset(0,oneFrameTime);


}

int DspX11OutputStream::getFrameusec() {
  return avSyncer->getFrameusec();
}

  
int DspX11OutputStream::getDepth() {
  return x11Window->getDepth();
}


int DspX11OutputStream::getOutputInit() {
  return lVideoInit;
}


void DspX11OutputStream::setOutputInit(int lInit) {
  this->lVideoInit=lInit;
}
 
 

void DspX11OutputStream::config(char* key, char* value) {
  if (strcmp(key,"-s")==0) {
    lavSync=false;
  }
  if (strcmp(key,"-b")==0) {
    avSyncer->config(key,value);
  }

}


AVSyncer* DspX11OutputStream::getAVSyncer() {
  return avSyncer;
}
