/*
  wrapper for X11 Window
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __X11WINDOW_H
#define __X11WINDOW_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <errno.h>
#include <pthread.h>
#include "xinit.h"
#include "picture.h"
#include "initDisplay.h"
#include "dither.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdlib.h>
#include <string.h>
#include "../inputPlugin/timeStamp.h"
#include "mmx.h"



class X11Window {

  XWindow* XWnd;
  int XShmMajor,XShmMinor;
  Bool XShmPixmaps;

  // things for the ditherthread
  pthread_mutex_t ditherMut;
  pthread_mutex_t changeMut;
  pthread_cond_t changeCond;
  pthread_t tr;

  TimeStamp* currentTime;
  TimeStamp* currentTimeMain;

  TimeStamp* startTime;
  TimeStamp* endTime;
  TimeStamp* totalWaitTime;
  TimeStamp* restWaitTime;
  

  int lDitherLoop;
  int linDitherLoop;
  int lPut;
  int lthreadDither;

  TimeStamp* threadWaitTime;
  TimeStamp* putTime;
  TimeStamp* ditherTime;
  TimeStamp* spendTime;
  int lmmx;



 public:
  X11Window(int lthreadDither);
  ~X11Window();

  int openWindow(int width, int height,char *title);
  void closeWindow();
  void flushWindow();

  void putImage(struct Picture* pic,TimeStamp* waitTime);
  int getDepth();

  // never call:
  void* ditherLoop();

 private:
  int createImage(int accessAllow);

  void PutXImage();
  int InitXWindow(int width, int height,char *title);
  void resizeWindow(unsigned int w,unsigned int h);
  void ditherPicture(struct Picture* pic);

  struct Picture* currentPic;
  void ditherLock();
  void ditherUnlock();
  void waitRestTime();

};
#endif
